/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.utils.TimeZones;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;

public class TimeZoneSelectionDialog
extends Dialog {
    private String title = "Time zone selector";
    private TableViewer tableViewer;
    private TimeZones zones = new TimeZones();
    private TimeZone timeZone;
    private Button okButton;
    private Image dstImage = ImageHolder.getInstance().getImage("/icons/clock.gif");

    public TimeZoneSelectionDialog(Shell shell) {
        super(shell);
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        String[] names;
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        container.setLayout((Layout)gridLayout);
        Composite topComposite = new Composite(container, 0);
        topComposite.setLayout((Layout)new GridLayout(4, true));
        topComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        String[] stringArray = names = new String[]{"America", "Africa", "Asia", "Atlantic", "Australia", "Europe", "Indian", "Pacific"};
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            final Button button = new Button(topComposite, 16);
            button.setText(name);
            button.setSelection(false);
            button.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
            button.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (button.getSelection()) {
                        TimeZoneSelectionDialog.this.showTimeZones(button.getText());
                    }
                }
            });
            ++n2;
        }
        this.tableViewer = new TableViewer(container, 68352);
        this.tableViewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        final Table table = this.tableViewer.getTable();
        table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TimeZoneSelectionDialog.this.timeZone = null;
                TimeZoneSelectionDialog.this.okButton.setEnabled(false);
                int index = table.getSelectionIndex();
                if (index != -1) {
                    TimeZoneSelectionDialog.this.timeZone = (TimeZone)table.getItem(index).getData();
                    TimeZoneSelectionDialog.this.okButton.setEnabled(true);
                }
            }
        });
        GridData gd = new GridData();
        gd.horizontalSpan = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 1;
        gd.heightHint = 350;
        gd.widthHint = 450;
        table.setLayoutData((Object)gd);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(20, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(20, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(20, true));
        TableColumn col = new TableColumn(table, 16384, 0);
        col.setText("Time zone");
        col = new TableColumn(table, 16384, 1);
        col.setText("Details");
        CLabel label = new CLabel(container, 0);
        label.setLayoutData((Object)new GridData(4, 2, true, false, 4, 1));
        label.setImage(this.dstImage);
        label.setText("means that a time zone is currently in daylight savings");
        return container;
    }

    protected void showTimeZones(String continent) {
        Table table = this.tableViewer.getTable();
        table.removeAll();
        Date today = new Date();
        List<TimeZone> list = this.zones.getTimeZones();
        for (TimeZone tz : list) {
            if (!tz.getID().startsWith(continent)) continue;
            TableItem item = new TableItem(table, 0);
            item.setData((Object)tz);
            int rawOffset = tz.getRawOffset();
            int hour = rawOffset / 3600000;
            int min = Math.abs(rawOffset / 60000) % 60;
            String details = String.format("(GMT%s%02d:%02d) %s", hour > 0 ? "+" : "-", Math.abs(hour), min, tz.getDisplayName(tz.inDaylightTime(today), 1));
            item.setText(0, tz.getID());
            item.setImage(tz.inDaylightTime(today) ? this.dstImage : null);
            item.setText(1, details);
        }
        TableColumn column = table.getColumn(0);
        column.pack();
        column = table.getColumn(1);
        column.pack();
        this.okButton.setEnabled(false);
    }

    public TimeZone getSelectedTimeZone() {
        return this.timeZone;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Point getInitialLocation(Point initialSize) {
        return Display.getCurrent().getCursorLocation();
    }

    protected void okPressed() {
        super.okPressed();
    }
}

