/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.client.widgets.TagComposite;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TagDialog
extends Dialog {
    private TagComposite composite;
    private String originalName;
    private TagVO tag;

    public TagDialog(Shell shell, TagVO tag) {
        super(shell);
        this.tag = tag.clone();
        this.originalName = tag.getName();
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        container.setLayout((Layout)gridLayout);
        this.composite = new TagComposite(container, this.tag);
        this.composite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.getShell().setMinimumSize(this.composite.getSize().x + 120, 500);
        return container;
    }

    protected void okPressed() {
        this.composite.save();
        TagsModel model = TagsModel.getInstance();
        if (this.originalName.equals(this.tag.getName())) {
            model.store(this.tag);
        } else {
            model.replace(this.originalName, this.tag);
        }
        model.fireContextChanged();
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Tag");
        newShell.setImage(ImageHolder.getInstance().getImage("icons/tag.gif"));
    }

    protected Point getInitialLocation(Point initialSize) {
        return Utils.getCenterPoint(initialSize);
    }
}

