/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.utils.Sound;
import com.moonlit.logfaces.client.utils.Utils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class SoundDlg
extends Dialog {
    private List list;
    private Sound sound;
    private int selected;

    public SoundDlg(Shell parentShell, int selected) {
        super(parentShell);
        this.setShellStyle(67680);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        this.list = new List(container, 2820);
        this.list.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        Sound[] soundArray = Sound.values();
        int n = soundArray.length;
        int n2 = 0;
        while (n2 < n) {
            Sound s = soundArray[n2];
            this.list.add(s.toString());
            ++n2;
        }
        this.list.remove(0);
        this.list.select(this.selected);
        this.list.setFocus();
        this.list.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (SoundDlg.this.list.getSelectionIndex() > 0) {
                    SoundDlg.this.sound = Sound.values()[SoundDlg.this.list.getSelectionIndex()];
                }
            }

            public void widgetSelected(SelectionEvent e) {
                if (SoundDlg.this.list.getSelectionIndex() > 0) {
                    SoundDlg.this.sound = Sound.values()[SoundDlg.this.list.getSelectionIndex()];
                }
            }
        });
        this.list.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    SoundDlg.this.buttonPressed(0);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 9, "Play sound", false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialLocation(Point initialSize) {
        return Display.getCurrent().getCursorLocation();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select sound");
        newShell.setImage(ImageHolder.getInstance().getImage("/icons/play.gif"));
    }

    protected void buttonPressed(int buttonId) {
        if (this.list.getSelectionIndex() < 0) {
            return;
        }
        this.sound = Sound.values()[this.list.getSelectionIndex() + 1];
        switch (buttonId) {
            case 0: {
                super.okPressed();
                break;
            }
            case 9: {
                Utils.playSound(this.sound.ordinal());
                break;
            }
            case 1: {
                super.cancelPressed();
            }
        }
    }

    public Sound getSound() {
        return this.sound;
    }
}

