/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.dialogs.DateTimeChooser;
import com.moonlit.logfaces.client.dialogs.DateTimeRangeChooser;
import com.moonlit.logfaces.client.dialogs.TimeZoneSelectionDialog;
import com.moonlit.logfaces.client.jobs.UpdatePinJob;
import com.moonlit.logfaces.client.model.QueryModel;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.types.SizeLimit;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.client.widgets.CriteriaComposite;
import com.moonlit.logfaces.server.core.Order;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class QueryDialog
extends Dialog {
    private CriteriaComposite criteriaComposite;
    private QueryVO currentQuery;
    private Combo rangeTypeCombo;
    private Combo sizeCombo;
    private Combo orderCombo;
    private Link timeZoneLink;
    private Link rangeLink;
    private Button exButton;
    private Text queryName;
    private boolean displayName;
    private IDialogSettings settings = Application.getDialogSettings();
    private SimpleDateFormat dtfDay = new SimpleDateFormat("dd MMMM yyyy");
    private SimpleDateFormat dtfRange = new SimpleDateFormat("dd MMMM yyyy, HH:mm:ss");
    private static final Logger log = LogManager.getLogger(QueryDialog.class);

    public QueryDialog() {
        this(Application.getShell(), new QueryVO(), false);
    }

    public QueryDialog(Shell parent, QueryVO query, boolean displayName) {
        super(parent);
        this.currentQuery = query;
        this.displayName = displayName;
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Label label;
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        container.setLayout((Layout)gridLayout);
        if (this.displayName) {
            label = new Label(container, 0);
            label.setText("Specify a friendly name for this query:");
            label.setLayoutData((Object)new GridData(4, 2, false, false, 4, 1));
            this.queryName = new Text(container, 2048);
            this.queryName.setLayoutData((Object)new GridData(4, 2, false, false, 4, 1));
            this.queryName.setText(this.currentQuery.getName());
            this.queryName.setEnabled(true);
        }
        label = new Label(container, 0);
        label.setText("Specify time range, size limitation and sorting order:");
        label.setLayoutData((Object)new GridData(1, 2, true, false, 4, 1));
        this.rangeTypeCombo = new Combo(container, 8);
        this.rangeTypeCombo.setToolTipText("Time range for the query");
        this.rangeTypeCombo.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.rangeTypeCombo.addSelectionListener((SelectionListener)new RangeTypeListener());
        this.rangeTypeCombo.setVisibleItemCount(15);
        this.rangeTypeCombo.add(TimeRange.BEFORE_5_MIN.toString());
        this.rangeTypeCombo.add(TimeRange.BEFORE_15_MIN.toString());
        this.rangeTypeCombo.add(TimeRange.BEFORE_30_MIN.toString());
        this.rangeTypeCombo.add(TimeRange.BEFORE_1_HOUR.toString());
        this.rangeTypeCombo.add(TimeRange.BEFORE_2_HOURS.toString());
        this.rangeTypeCombo.add(TimeRange.BEFORE_4_HOURS.toString());
        this.rangeTypeCombo.add(TimeRange.BEFORE_8_HOURS.toString());
        this.rangeTypeCombo.add(TimeRange.BEFORE_1_DAY.toString());
        this.rangeTypeCombo.add(TimeRange.BEFORE_2_DAY.toString());
        this.rangeTypeCombo.add(TimeRange.BEFORE_1_WEEK.toString());
        this.rangeTypeCombo.add(TimeRange.BEFORE_2_WEEKS.toString());
        this.rangeTypeCombo.add(TimeRange.BEFORE_1_MONTH.toString());
        this.rangeTypeCombo.add(TimeRange.PARTICULAR_DAY.toString());
        this.rangeTypeCombo.add(TimeRange.CUSTOM_RANGE.toString());
        this.rangeTypeCombo.add(TimeRange.ALL.toString());
        TimeRange range = this.currentQuery.getRange();
        int i = 0;
        while (i < this.rangeTypeCombo.getItemCount()) {
            if (this.rangeTypeCombo.getItem(i).equals(range.toString())) {
                this.rangeTypeCombo.select(i);
                break;
            }
            ++i;
        }
        this.sizeCombo = new Combo(container, 8);
        this.sizeCombo.setToolTipText("Fetch size limitation");
        this.sizeCombo.addSelectionListener((SelectionListener)new SizeTypeListener());
        this.sizeCombo.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.sizeCombo.setVisibleItemCount(10);
        SizeLimit[] sizeLimitArray = SizeLimit.values();
        int n = sizeLimitArray.length;
        int n2 = 0;
        while (n2 < n) {
            SizeLimit limit = sizeLimitArray[n2];
            this.sizeCombo.add(limit.toString());
            ++n2;
        }
        this.orderCombo = new Combo(container, 8);
        this.orderCombo.setToolTipText("Display results sorted by time stamp in this order");
        this.orderCombo.addSelectionListener((SelectionListener)new OrderListener());
        sizeLimitArray = Order.values();
        n = sizeLimitArray.length;
        n2 = 0;
        while (n2 < n) {
            SizeLimit order = sizeLimitArray[n2];
            this.orderCombo.add(order.toDisplay());
            ++n2;
        }
        this.orderCombo.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.timeZoneLink = new Link(container, 0);
        this.timeZoneLink.setForeground(new Color(null, 0, 0, 255));
        this.timeZoneLink.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        this.timeZoneLink.addMouseListener((MouseListener)new TimeZoneLinkListener());
        this.rangeLink = new Link(container, 0);
        this.rangeLink.setLayoutData((Object)new GridData(4, 2, false, false, 2, 1));
        this.rangeLink.setVisible(false);
        this.rangeLink.addMouseListener((MouseListener)new RangeLinkListener());
        this.exButton = new Button(container, 32);
        this.exButton.setText("Fetch stack traces");
        this.exButton.setToolTipText("Throwable info can be fetched instanly (checked)\nOr lazy loaded later when required (much faster)");
        this.exButton.setLayoutData((Object)new GridData(4, 2, false, false, 2, 1));
        this.exButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryDialog.this.currentQuery.setFetchThrowable(QueryDialog.this.exButton.getSelection());
            }
        });
        label = new Label(container, 258);
        label.setText("");
        label.setLayoutData((Object)new GridData(4, 2, false, false, 4, 1));
        label = new Label(container, 0);
        label.setText("Use this criteria to fetch log data:");
        label.setLayoutData((Object)new GridData(4, 2, false, false, 4, 1));
        this.criteriaComposite = new CriteriaComposite(container, this.currentQuery);
        this.criteriaComposite.setLayoutData(new GridData(4, 4, true, true, 4, 1));
        this.criteriaComposite.setFocus();
        this.getShell().setMinimumSize(600, 500);
        this.populate();
        return container;
    }

    private void populate() {
        TimeRange range = this.currentQuery.getRange();
        int i = 0;
        while (i < this.rangeTypeCombo.getItemCount()) {
            if (this.rangeTypeCombo.getItem(i).equals(range.toString())) {
                this.rangeTypeCombo.select(i);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.sizeCombo.getItemCount()) {
            SizeLimit limit = SizeLimit.fromString(this.sizeCombo.getItem(i));
            if (SizeLimit.fromInteger(this.currentQuery.getLimit()) == limit) {
                this.sizeCombo.select(limit.ordinal());
                break;
            }
            ++i;
        }
        this.orderCombo.select(this.currentQuery.getOrder().ordinal());
        this.timeZoneLink.setText(String.format("<a>%s</a>", this.currentQuery.getTimeZone().getID()));
        this.rangeLink.setVisible(false);
        this.exButton.setSelection(this.currentQuery.isFetchThrowable());
        switch (range) {
            case PARTICULAR_DAY: {
                this.rangeLink.setVisible(true);
                this.rangeLink.setText(String.format("<a>%s</a>", this.dtfDay.format(this.currentQuery.getFromTime())));
                break;
            }
            case CUSTOM_RANGE: {
                this.rangeLink.setVisible(true);
                this.rangeLink.setText(String.format("<a>%s -- %s</a>", this.dtfRange.format(this.currentQuery.getFromTime()), this.dtfRange.format(this.currentQuery.getToTime())));
                break;
            }
        }
        this.criteriaComposite.setCriteria(this.currentQuery.getCriteria());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ImageHolder images = ImageHolder.getInstance();
        Button button = this.createButton(parent, 256, "Save", false);
        button.setToolTipText("Save this query for later use");
        button.setImage(images.getButtonImage("/icons/saveas_edit.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!QueryDialog.this.saveas()) {
                    return;
                }
                QueryDialog.this.setReturnCode(2);
                QueryDialog.this.close();
            }
        });
        button = this.createButton(parent, 256, "Import", false);
        button.setImage(images.getButtonImage("/icons/eclipse3_import.gif"));
        button.setToolTipText("Import query from file and populate controls");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryDialog.this.importFile();
            }
        });
        button = this.createButton(parent, 256, "Export", false);
        button.setImage(images.getButtonImage("/icons/eclipse3_export.gif"));
        button.setToolTipText("Export this query parameters to a file");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryDialog.this.exportFile();
            }
        });
        button = this.createButton(parent, 0, "Run", true);
        button.setToolTipText("Execute the query and display results");
        button.setImage(images.getButtonImage("icons/run_exc.gif"));
        button = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        button.setImage(images.getButtonImage("icons/eclipse3_remove.gif"));
    }

    protected Point getInitialLocation(Point initialSize) {
        return Display.getCurrent().getCursorLocation();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Query");
        newShell.setImage(ImageHolder.getInstance().getImage("icons/query.gif"));
        try {
            newShell.setSize(this.settings.getInt("QueryDialog.x"), this.settings.getInt("QueryDialog.y"));
            newShell.setLocation(this.settings.getInt("QueryDialog.lx"), this.settings.getInt("QueryDialog.ly"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void okPressed() {
        CriteriaFilter criteria = this.criteriaComposite.getCriteria();
        this.currentQuery.setCriteria(criteria);
        this.currentQuery.setEscapeSql(this.criteriaComposite.isEscape());
        if (this.displayName) {
            this.currentQuery.setName(this.queryName.getText());
        }
        this.persist();
        super.okPressed();
    }

    private void persist() {
        Point size = this.getShell().getSize();
        Point location = this.getShell().getLocation();
        this.settings.put("QueryDialog.x", size.x);
        this.settings.put("QueryDialog.y", size.y);
        this.settings.put("QueryDialog.lx", location.x);
        this.settings.put("QueryDialog.ly", location.y);
    }

    private boolean saveas() {
        String name;
        CriteriaFilter criteria = this.criteriaComposite.getCriteria();
        this.currentQuery.setCriteria(criteria);
        String string = name = this.queryName != null ? this.queryName.getText() : this.currentQuery.getName();
        if (!this.displayName) {
            InputDialog dialog = new InputDialog(this.getShell(), "Query name", "Please give this query a firendly name:", this.currentQuery.getName(), null);
            if (dialog.open() != 0) {
                return false;
            }
            name = dialog.getValue();
        }
        this.currentQuery.setName(name);
        QueryModel.getInstance().addQuery(this.currentQuery);
        if (this.currentQuery.isPin()) {
            UpdatePinJob.run(this.currentQuery);
        }
        return true;
    }

    private void importFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText("Specify the file name");
        dialog.setFilterExtensions(new String[]{"*.lfq", "*.*"});
        dialog.setFilterNames(new String[]{"query files (*.lfq)", "All files (*.*)"});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        try {
            QueryVO qvo = QueryVO.load(new File(path));
            this.currentQuery.copy(qvo);
            this.populate();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Failed", (String)e.getMessage());
        }
    }

    private void exportFile() {
        CriteriaFilter criteria = this.criteriaComposite.getCriteria();
        this.currentQuery.setCriteria(criteria);
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText("Specify the file name");
        dialog.setFilterExtensions(new String[]{"*.lfq", "*.*"});
        dialog.setFilterNames(new String[]{"query files (*.lfq)", "All files (*.*)"});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        try {
            this.currentQuery.save(new File(path));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Failed", (String)e.getMessage());
        }
    }

    public QueryVO getResult() {
        return this.currentQuery;
    }

    class OrderListener
    implements SelectionListener {
        OrderListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                Order order = Order.values()[QueryDialog.this.orderCombo.getSelectionIndex()];
                QueryDialog.this.currentQuery.setOrder(order);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    class RangeLinkListener
    extends MouseAdapter {
        RangeLinkListener() {
        }

        public void mouseDown(MouseEvent e) {
            if (TimeRange.PARTICULAR_DAY.equals((Object)QueryDialog.this.currentQuery.getRange())) {
                DateTimeChooser dlg = new DateTimeChooser(QueryDialog.this.getShell(), QueryDialog.this.currentQuery.getFromTime(), QueryDialog.this.currentQuery.getTimeZone());
                dlg.setTimeVisible(false);
                if (dlg.open() > 0) {
                    return;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(dlg.getTime());
                calendar.set(10, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                long t1 = calendar.getTimeInMillis();
                long t2 = t1 + 86400000L - 1L;
                QueryDialog.this.currentQuery.setTimeRange(TimeRange.PARTICULAR_DAY, t1, t2);
                QueryDialog.this.rangeLink.setVisible(true);
                QueryDialog.this.rangeLink.setText(String.format("<a>%s</a>", QueryDialog.this.dtfDay.format(t1)));
            } else if (TimeRange.CUSTOM_RANGE.equals((Object)QueryDialog.this.currentQuery.getRange())) {
                DateTimeRangeChooser dlg = new DateTimeRangeChooser(QueryDialog.this.getShell(), QueryDialog.this.currentQuery.getFromTime(), QueryDialog.this.currentQuery.getToTime(), QueryDialog.this.currentQuery.getTimeZone());
                if (dlg.open() > 0) {
                    return;
                }
                QueryDialog.this.currentQuery.setTimeRange(TimeRange.CUSTOM_RANGE, dlg.getTime(), dlg.getTime2());
                QueryDialog.this.rangeLink.setVisible(true);
                QueryDialog.this.rangeLink.setText(String.format("<a>%s -- %s</a>", QueryDialog.this.dtfRange.format(dlg.getTime()), QueryDialog.this.dtfRange.format(dlg.getTime2())));
            }
        }
    }

    class RangeTypeListener
    implements SelectionListener {
        RangeTypeListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            long now = System.currentTimeMillis();
            if (TimeRange.PARTICULAR_DAY.is(QueryDialog.this.rangeTypeCombo.getText())) {
                DateTimeChooser dlg = new DateTimeChooser(QueryDialog.this.getShell(), now, QueryDialog.this.currentQuery.getTimeZone());
                dlg.setTimeVisible(false);
                if (dlg.open() > 0) {
                    return;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(dlg.getTime());
                calendar.set(10, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                long t1 = calendar.getTimeInMillis();
                long t2 = t1 + 86400000L - 1L;
                QueryDialog.this.currentQuery.setTimeRange(TimeRange.PARTICULAR_DAY, t1, t2);
                QueryDialog.this.rangeLink.setVisible(true);
                QueryDialog.this.rangeLink.setText(String.format("<a>%s</a>", QueryDialog.this.dtfDay.format(t1)));
            } else if (TimeRange.CUSTOM_RANGE.is(QueryDialog.this.rangeTypeCombo.getText())) {
                DateTimeRangeChooser dlg = new DateTimeRangeChooser(QueryDialog.this.getShell(), now - 3600000L, now, QueryDialog.this.currentQuery.getTimeZone());
                if (dlg.open() > 0) {
                    return;
                }
                QueryDialog.this.currentQuery.setTimeRange(TimeRange.CUSTOM_RANGE, dlg.getTime(), dlg.getTime2());
                QueryDialog.this.rangeLink.setVisible(true);
                QueryDialog.this.rangeLink.setText(String.format("<a>%s -- %s</a>", QueryDialog.this.dtfRange.format(dlg.getTime()), QueryDialog.this.dtfRange.format(dlg.getTime2())));
            } else {
                QueryDialog.this.currentQuery.setTimeRange(TimeRange.fromString(QueryDialog.this.rangeTypeCombo.getText()), 0L, 0L);
                QueryDialog.this.rangeLink.setVisible(false);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    class SizeTypeListener
    implements SelectionListener {
        SizeTypeListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (QueryDialog.this.sizeCombo.getSelectionIndex() != -1) {
                QueryDialog.this.currentQuery.setLimit(SizeLimit.fromString(QueryDialog.this.sizeCombo.getText()).getSizeLimit());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    class TimeZoneLinkListener
    extends MouseAdapter {
        TimeZoneLinkListener() {
        }

        public void mouseDown(MouseEvent e) {
            TimeZone zone = QueryDialog.this.currentQuery.getTimeZone();
            if (zone.equals(TimeZone.getDefault())) {
                TimeZoneSelectionDialog dlg = new TimeZoneSelectionDialog(QueryDialog.this.getShell());
                if (dlg.open() != 0) {
                    return;
                }
                QueryDialog.this.currentQuery.setTimeZone(dlg.getSelectedTimeZone());
            } else {
                QueryDialog.this.currentQuery.setTimeZone(TimeZone.getDefault());
            }
            QueryDialog.this.timeZoneLink.setText(String.format("<a>%s</a>", QueryDialog.this.currentQuery.getTimeZone().getID()));
        }
    }
}

