/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.google.common.collect.Maps;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.server.core.LogFacesPlugin;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PluginArgumentsDialog
extends Dialog {
    private Map<String, Text> inputs = Maps.newLinkedHashMap();
    private Map<String, String> arguments;
    private EnterKeyListener keylistener;
    private LogFacesPlugin plugin;
    private IDialogSettings settings;

    public PluginArgumentsDialog(Shell parentShell, LogFacesPlugin plugin) {
        super(parentShell);
        this.plugin = plugin;
        this.settings = Application.getDialogSettings(String.format("PluginArgumentsDialog.%s", plugin.getName()), true);
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        this.keylistener = new EnterKeyListener();
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 64);
        label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        label.setText("This plugin may require the following arguments for the operation");
        label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        for (String name : this.plugin.getArgs()) {
            this.addInput(composite, name);
        }
        this.inputs.values().iterator().next().setFocus();
        composite.pack();
        return composite;
    }

    private void addInput(Composite parent, String name) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(3, 2, false, false));
        label.setText(name);
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(4, 2, true, false));
        String value = this.settings.get(name);
        text.setText(value != null ? value : "");
        text.setFocus();
        text.addKeyListener((KeyListener)this.keylistener);
        this.inputs.put(name, text);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialLocation(Point initialSize) {
        return Display.getCurrent().getCursorLocation();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.plugin.getName());
        newShell.setImage(ImageHolder.getInstance().getImage("/icons/plugin.gif"));
    }

    protected void okPressed() {
        this.arguments = Maps.newLinkedHashMap();
        for (String name : this.plugin.getArgs()) {
            String value = this.inputs.get(name).getText();
            this.arguments.put(name.toLowerCase(), value);
            this.settings.put(name, value);
        }
        super.okPressed();
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    class EnterKeyListener
    implements KeyListener {
        EnterKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                PluginArgumentsDialog.this.okPressed();
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

