/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.model.ParserVO;
import com.moonlit.logfaces.client.model.RegexVO;
import com.moonlit.logfaces.server.conf.Options;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.receivers.Parser;
import com.moonlit.logfaces.server.receivers.ParserListener;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PatternsTestDialog
extends Dialog {
    private Text input;
    private Text pattern;
    private Text output;
    private String expression;
    private IDialogSettings settings = Application.getDialogSettings();
    private ParserVO parserVO;

    public PatternsTestDialog(Shell shell) {
        this(shell, (String)null);
    }

    public PatternsTestDialog(Shell shell, String expression) {
        super(shell);
        this.expression = expression;
        this.setShellStyle(2160);
    }

    public PatternsTestDialog(Shell shell, ParserVO parserVO) {
        super(shell);
        this.parserVO = parserVO;
        this.setShellStyle(2160);
    }

    protected Control createDialogArea(Composite parent) {
        String temp;
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        container.setLayout((Layout)gridLayout);
        String string = temp = this.expression == null ? this.settings.get("PatternsTestDialog.pattern") : this.expression;
        if (this.parserVO != null) {
            temp = this.parserVO.getPattern();
        }
        GridData lgd = new GridData(4, 1, true, false, 1, 1);
        Label label = new Label(container, 0);
        label.setLayoutData((Object)lgd);
        label.setText("Regular expression:");
        this.pattern = new Text(container, 2048);
        this.pattern.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        this.pattern.setText(temp != null ? temp : "");
        temp = this.settings.get("PatternsTestDialog.input");
        label = new Label(container, 0);
        label.setLayoutData((Object)lgd);
        label.setText("Text to match:");
        GridData gd = new GridData(4, 1, true, false, 1, 1);
        gd.heightHint = 80;
        this.input = new Text(container, 2818);
        this.input.setLayoutData((Object)gd);
        this.input.setText(temp != null ? temp : "");
        this.input.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 97) {
                    PatternsTestDialog.this.input.selectAll();
                }
            }
        });
        label = new Label(container, 0);
        label.setLayoutData((Object)lgd);
        label.setText("Results:");
        this.output = new Text(container, 2818);
        this.output.setEditable(false);
        this.output.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        new Label(container, 0);
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Patterns tester");
        try {
            newShell.setSize(this.settings.getInt("PatternsTestDialog.x"), this.settings.getInt("PatternsTestDialog.y"));
            newShell.setLocation(this.settings.getInt("PatternsTestDialog.lx"), this.settings.getInt("PatternsTestDialog.ly"));
        }
        catch (Exception e) {
            newShell.setSize(600, 600);
            newShell.setLocation(Display.getCurrent().getCursorLocation());
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ImageHolder images = ImageHolder.getInstance();
        Button button = this.createButton(parent, 256, "Match and extract groups", false);
        button.setToolTipText("Will try to match input text against regular expression\nIf groups are present, the values will be extracted.");
        button.setImage(images.getButtonImage("icons/eclipse3_view.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatternsTestDialog.this.persist();
                PatternsTestDialog.this.matchExpression();
            }
        });
        button = this.createButton(parent, 256, "Parse as log events", false);
        button.setToolTipText("Parse input text using regular expression into log events\nResults will be displayed in JSON format per event parsed.");
        button.setImage(images.getButtonImage("icons/level_debug3.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatternsTestDialog.this.persist();
                PatternsTestDialog.this.matchEvents();
            }
        });
        GridData gd = (GridData)button.getLayoutData();
        gd.widthHint = 200;
    }

    private void persist() {
        this.settings.put("PatternsTestDialog.pattern", this.pattern.getText());
        this.settings.put("PatternsTestDialog.input", this.input.getText());
        Point size = this.getShell().getSize();
        Point location = this.getShell().getLocation();
        this.settings.put("PatternsTestDialog.x", size.x);
        this.settings.put("PatternsTestDialog.y", size.y);
        this.settings.put("PatternsTestDialog.lx", location.x);
        this.settings.put("PatternsTestDialog.ly", location.y);
    }

    private void matchEvents() {
        File tempFile = new File(String.format("%s%s%d", Platform.getConfigurationLocation().getURL().getPath(), File.separator, System.currentTimeMillis()));
        File libFile = new File(String.format("%s%spatterns.properties", Platform.getConfigurationLocation().getURL().getPath(), File.separator));
        if (!libFile.exists()) {
            this.output.setText("no pattern library file");
            return;
        }
        try {
            try {
                FileWriter writer = new FileWriter(tempFile);
                writer.write(this.input.getText());
                writer.flush();
                writer.close();
                final ArrayList events = Lists.newArrayList();
                Parser parser = new Parser(new ParserListener(){

                    public void parsingStarted() {
                    }

                    public void lineParsed(LogEvent event) {
                        events.add(event);
                    }

                    public void lineFailed(String line) {
                        events.add("FAILED PARSING LINE - " + line);
                    }

                    public void parsingEnded(long pointer) {
                    }

                    public void parsingFailed(Throwable error, long pointer) {
                        events.add(error.getMessage());
                    }
                }, libFile.getPath());
                Options options = new Options();
                options.setProperty("pattern", (Object)this.pattern.getText());
                options.setProperty("xpattern", (Object)(this.parserVO != null ? this.parserVO.getPatternEx() : "%{JEX}"));
                if (this.parserVO != null) {
                    options.setProperty("dtf", (Object)this.parserVO.getDtf());
                }
                parser.parse(tempFile, options, 0L);
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                this.output.setText(events.isEmpty() ? "this produced nothing.." : gson.toJson((Object)events));
            }
            catch (Exception e) {
                this.output.setText(e.getMessage());
                FileUtils.deleteQuietly((File)tempFile);
            }
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    private void matchExpression() {
        RegexVO regex = new RegexVO(this.pattern.getText());
        StringBuffer result = new StringBuffer();
        Map<String, String> groups = regex.extractAll(this.input.getText());
        if (groups == null) {
            this.output.setText("no match");
            return;
        }
        for (String group : groups.keySet()) {
            result.append(String.format("%s : %s%n", group, groups.get(group)));
        }
        this.output.setText(result.toString().isEmpty() ? "match, but no groups captured" : result.toString());
    }
}

