/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.utils.StringUtils;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParserInputDialog
extends Dialog {
    private Combo comboPattern;
    private Combo comboXpattern;
    private Combo comboDtf;
    private Text textFile;
    private String pattern;
    private String xpattern;
    private String dtf;
    private String file;
    private IDialogSettings settings;
    private List<String> patterns = Lists.newArrayList();
    private List<String> xpatterns = Lists.newArrayList();
    private List<String> dtfs = Lists.newArrayList();

    public ParserInputDialog(Shell shell) {
        super(shell);
        this.setShellStyle(67696);
        this.settings = Application.getDialogSettings();
        String[] arr = this.settings.getArray("ParserInputDialog.patterns");
        if (arr != null) {
            this.patterns = Lists.newArrayList(Arrays.asList(arr));
        }
        if ((arr = this.settings.getArray("ParserInputDialog.xpatterns")) != null) {
            this.xpatterns = Lists.newArrayList(Arrays.asList(arr));
        }
        if ((arr = this.settings.getArray("ParserInputDialog.dtfs")) != null) {
            this.dtfs = Lists.newArrayList(Arrays.asList(arr));
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        GridData gd = new GridData(4, 2, true, false, 1, 1);
        gd.widthHint = 400;
        CLabel title = new CLabel(container, 0);
        title.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        title.setBottomMargin(10);
        title.setText("To parse raw text file in arbitrary format the following input is required:\n1. Regular expression pattern for matching each line in the file\n2. Regular expression pattern for matching exception stack traces (if relevant)\n3. Date time format for converting text info actual time stamp");
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData());
        label.setText("Main pattern:");
        this.comboPattern = new Combo(container, 4);
        this.comboPattern.setLayoutData((Object)gd);
        this.comboPattern.setFocus();
        for (String string : this.patterns) {
            this.comboPattern.add(string);
            this.comboPattern.setText(string);
        }
        label = new Label(container, 0);
        label.setLayoutData((Object)new GridData());
        label.setText("X pattern (optional):");
        this.comboXpattern = new Combo(container, 4);
        this.comboXpattern.setLayoutData((Object)gd);
        for (String string : this.xpatterns) {
            this.comboXpattern.add(string);
            this.comboXpattern.setText(string);
        }
        label = new Label(container, 0);
        label.setLayoutData((Object)new GridData());
        label.setText("Date time format:");
        this.comboDtf = new Combo(container, 4);
        this.comboDtf.setLayoutData((Object)gd);
        for (String string : this.dtfs) {
            this.comboDtf.add(string);
            this.comboDtf.setText(string);
        }
        label = new Label(container, 0);
        label.setLayoutData((Object)new GridData());
        label.setText("File name:");
        String fileName = this.settings.get("ParserInputDialog.file");
        this.textFile = new Text(container, 2048);
        this.textFile.setText(fileName != null ? fileName : "");
        this.textFile.setEditable(false);
        this.textFile.setLayoutData((Object)gd);
        try {
            this.comboPattern.select(this.settings.getInt("ParserInputDialog.pattern"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.comboXpattern.select(this.settings.getInt("ParserInputDialog.xpattern"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.comboDtf.select(this.settings.getInt("ParserInputDialog.dtf"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 256, "Select file", false);
        button.setImage(ImageHolder.getInstance().getImage("/icons/saveas_edit.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ParserInputDialog.this.getShell());
                dialog.setText("Log file name");
                dialog.setFilterExtensions(new String[]{"*.log", "*.*"});
                dialog.setFilterNames(new String[]{"log files (*.log)", "All files (*.*)"});
                String path = dialog.open();
                ParserInputDialog.this.textFile.setText(path != null ? path : "");
            }
        });
        button = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        button.setText("Parse");
        button.setImage(ImageHolder.getInstance().getImage("icons/run_exc.gif"));
        button.setFocus();
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Parser input");
        try {
            newShell.setSize(this.settings.getInt("ParserInputDialog.x"), this.settings.getInt("ParserInputDialog.y"));
            newShell.setLocation(this.settings.getInt("ParserInputDialog.lx"), this.settings.getInt("ParserInputDialog.ly"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void okPressed() {
        this.setPattern(this.comboPattern.getText());
        this.setXpattern(this.comboXpattern.getText());
        this.setDtf(this.comboDtf.getText());
        this.setFile(this.textFile.getText());
        if (!StringUtils.hasText(this.pattern) || !StringUtils.hasText(this.file)) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Missing input", (String)"Please select file and specify pattern");
            return;
        }
        Point size = this.getShell().getSize();
        Point location = this.getShell().getLocation();
        this.settings.put("ParserInputDialog.x", size.x);
        this.settings.put("ParserInputDialog.y", size.y);
        this.settings.put("ParserInputDialog.lx", location.x);
        this.settings.put("ParserInputDialog.ly", location.y);
        super.okPressed();
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        if (StringUtils.hasText(pattern) && !this.patterns.contains(pattern)) {
            this.patterns.add(pattern);
            this.settings.put("ParserInputDialog.patterns", (String[])Iterables.toArray(this.patterns, String.class));
        }
        this.settings.put("ParserInputDialog.pattern", this.patterns.indexOf(pattern));
    }

    public String getXpattern() {
        return this.xpattern;
    }

    public void setXpattern(String xpattern) {
        this.xpattern = xpattern;
        if (StringUtils.hasText(xpattern) && !this.xpatterns.contains(xpattern)) {
            this.xpatterns.add(xpattern);
            this.settings.put("ParserInputDialog.xpatterns", (String[])Iterables.toArray(this.xpatterns, String.class));
        }
        this.settings.put("ParserInputDialog.xpattern", this.xpatterns.indexOf(xpattern));
    }

    public String getDtf() {
        return StringUtils.hasText(this.dtf) ? this.dtf : null;
    }

    public void setDtf(String dtf) {
        this.dtf = dtf;
        if (!this.dtfs.contains(dtf)) {
            this.dtfs.add(dtf);
            this.settings.put("ParserInputDialog.dtfs", (String[])Iterables.toArray(this.dtfs, String.class));
        }
        this.settings.put("ParserInputDialog.dtf", this.dtfs.indexOf(dtf));
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
        if (StringUtils.hasText(file)) {
            this.settings.put("ParserInputDialog.file", file);
        }
    }
}

