/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.Workspace;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.server.util.Password;
import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewWorkspaceDialog
extends Dialog {
    private Text hostText;
    private Text portText;
    private Text nameText;
    private Text userNameText;
    private Text passwordText;
    private Button sslButton;
    private Button copyButton;
    private String host;
    private String name;
    private String user;
    private String password;
    private int port;
    private boolean ssl;
    private boolean copy;

    public NewWorkspaceDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(67696);
    }

    public void setRenameAllowed(boolean allowed) {
    }

    protected Control createDialogArea(Composite parent) {
        Workspace ws = WorkspaceHolder.getInstance().getCurrentWorkspace();
        EnterKeyListener listener = new EnterKeyListener();
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 64);
        label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        label.setText("Workspace is a profile containing artifacts you create during your work. Having several workspaces allows fast switching from one environment to the other. Along with a friendly name, you need to specify server connectivity parameters. When workspaces switched, the application will automatically connect to the specified server and load all relevant settings.");
        label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(3, 2, false, false));
        label.setText("Workspace name :");
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 2, true, false));
        this.nameText.setText(ws.getName() + " (copy)");
        this.nameText.setFocus();
        this.nameText.addKeyListener((KeyListener)listener);
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(3, 2, false, false));
        label.setText("logFaces server host :");
        this.hostText = new Text(composite, 2048);
        this.hostText.setLayoutData((Object)new GridData(4, 2, true, false));
        this.hostText.setText(ws.getServerHost());
        this.hostText.addKeyListener((KeyListener)listener);
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(3, 2, false, false));
        label.setText("logFaces server port :");
        this.portText = new Text(composite, 2048);
        this.portText.setLayoutData((Object)new GridData(4, 2, true, false));
        this.portText.setText("" + ws.getServerPort());
        this.portText.addKeyListener((KeyListener)listener);
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(3, 2, false, false));
        label.setText("Use SSL (if required by server) :");
        this.sslButton = new Button(composite, 32);
        this.sslButton.setLayoutData((Object)new GridData(4, 2, true, false));
        this.sslButton.addKeyListener((KeyListener)listener);
        this.sslButton.setSelection(ws.isSsl());
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(3, 2, false, false));
        label.setText("User name (if required by server) :");
        this.userNameText = new Text(composite, 2048);
        this.userNameText.setLayoutData((Object)new GridData(4, 2, true, false));
        this.userNameText.setText(ws.getUserName());
        this.userNameText.addKeyListener((KeyListener)listener);
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(3, 2, false, false));
        label.setText("Password (if required by server) :");
        this.passwordText = new Text(composite, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(4, 2, true, false));
        if (StringUtils.hasText(ws.getPassword())) {
            this.passwordText.setText(Password.deobfuscate((String)ws.getPassword()));
        }
        this.passwordText.addKeyListener((KeyListener)listener);
        label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.copyButton = new Button(composite, 32);
        this.copyButton.setSelection(true);
        this.copyButton.setLayoutData((Object)new GridData(3, 2, true, false, 2, 1));
        this.copyButton.addKeyListener((KeyListener)listener);
        this.copyButton.setText("Use current workspace as template");
        this.copyButton.setToolTipText("Check to duplicate current workspace.\nThis will copy everything from current workspace\nand apply the inputs you specify here");
        composite.pack();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialLocation(Point initialSize) {
        return Display.getCurrent().getCursorLocation();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setSize(500, 400);
        newShell.setText("New workspace");
        newShell.setImage(ImageHolder.getInstance().getImage("icons/add.gif"));
    }

    protected void okPressed() {
        this.name = this.nameText.getText();
        this.host = this.hostText.getText();
        this.user = this.userNameText.getText();
        this.password = this.passwordText.getText();
        this.port = Integer.parseInt(this.portText.getText());
        this.ssl = this.sslButton.getSelection();
        this.copy = this.copyButton.getSelection();
        if (this.getName().length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Wrong input", (String)"Please specify workspace name");
            return;
        }
        File file = new File(this.nameText.getText());
        try {
            file.createNewFile();
        }
        catch (Exception e1) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Wrong input", (String)"Please use only characters valid for file naming.");
            return;
        }
        file.delete();
        if (WorkspaceHolder.getInstance().getWorkspace(this.name) != null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Wrong input", (String)"Workspace with such name already exists, please choose another.");
            return;
        }
        if (this.getHost().length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Wrong input", (String)"Please specify server host name");
            return;
        }
        try {
            int port = this.getPort();
            if (port <= 0 || port > 65535) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Wrong input", (String)"Port number should be in range 1-65535");
            return;
        }
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        if (this.password != null && this.password.length() > 0) {
            Password.obfuscate((String)this.password);
        }
        return this.password;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public boolean isCopy() {
        return this.copy;
    }

    class EnterKeyListener
    implements KeyListener {
        EnterKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                NewWorkspaceDialog.this.okPressed();
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

