/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.dialogs.SoundDlg;
import com.moonlit.logfaces.client.dialogs.TimeZoneSelectionDialog;
import com.moonlit.logfaces.client.model.PerspectiveVO;
import com.moonlit.logfaces.client.utils.Sound;
import com.moonlit.logfaces.client.widgets.CriteriaComposite;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import java.util.TimeZone;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LogPerspectiveDlg
extends Dialog {
    private PerspectiveVO vo;
    private Text perspNameText;
    private CriteriaComposite criteriaComposite;
    private boolean renameAllowed = true;

    public LogPerspectiveDlg(Shell parent, PerspectiveVO vo) {
        super(parent);
        this.setShellStyle(67696);
        this.vo = vo;
    }

    public void setRenameAllowed(boolean allowed) {
        this.renameAllowed = allowed;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        container.setLayout((Layout)gridLayout);
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        label.setText("Perspective name :");
        this.perspNameText = new Text(container, 2048);
        this.perspNameText.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        this.perspNameText.setText(this.vo.getName());
        if (!this.renameAllowed) {
            this.perspNameText.setEnabled(false);
        }
        final Button nudgeButton = new Button(container, 32);
        nudgeButton.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        nudgeButton.setText("Sound on problems");
        nudgeButton.setToolTipText("Will make a sound when events with WARN+ severity or thrown exceptions received");
        nudgeButton.setSelection(this.vo.getNudge() > 0);
        nudgeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!nudgeButton.getSelection()) {
                    LogPerspectiveDlg.this.vo.setNudge(Sound.none.ordinal());
                    return;
                }
                SoundDlg dlg = new SoundDlg(LogPerspectiveDlg.this.getShell(), LogPerspectiveDlg.this.vo.getNudge());
                if (dlg.open() == 0) {
                    LogPerspectiveDlg.this.vo.setNudge(dlg.getSound().ordinal());
                } else {
                    nudgeButton.setSelection(false);
                }
            }
        });
        final Button baloonButton = new Button(container, 32);
        baloonButton.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        baloonButton.setText("Balloon on problems");
        baloonButton.setToolTipText("Will display tray popup when events with WARN+ severity or thrown exceptions received");
        baloonButton.setSelection(this.vo.isBaloon());
        baloonButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogPerspectiveDlg.this.vo.setBaloon(baloonButton.getSelection());
            }
        });
        boolean defaultTimeZone = this.vo.getTimeZone().equals(TimeZone.getDefault());
        final Button useMyTimezone = new Button(container, 16);
        useMyTimezone.setSelection(defaultTimeZone);
        useMyTimezone.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        useMyTimezone.setText("Use my time zone");
        useMyTimezone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (useMyTimezone.getSelection()) {
                    LogPerspectiveDlg.this.vo.setTimeZone(TimeZone.getDefault());
                }
            }
        });
        final Button otherTimezone = new Button(container, 16);
        otherTimezone.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        otherTimezone.setSelection(!defaultTimeZone);
        if (defaultTimeZone) {
            otherTimezone.setText("Select other time zone");
        } else {
            otherTimezone.setText("Use " + this.vo.getTimeZone().getID() + " time zone");
        }
        otherTimezone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!otherTimezone.getSelection()) {
                    otherTimezone.setText("Select other time zone");
                    return;
                }
                TimeZoneSelectionDialog dlg = new TimeZoneSelectionDialog(LogPerspectiveDlg.this.getShell());
                if (dlg.open() == 0) {
                    TimeZone tz = dlg.getSelectedTimeZone();
                    LogPerspectiveDlg.this.vo.setTimeZone(tz);
                    otherTimezone.setText("Use " + tz.getID() + " time zone");
                } else if (LogPerspectiveDlg.this.vo.getTimeZone().equals(TimeZone.getDefault())) {
                    otherTimezone.setSelection(false);
                    otherTimezone.setText("Select other time zone");
                    useMyTimezone.setSelection(true);
                }
            }
        });
        final Button wakeupButton = new Button(container, 32);
        wakeupButton.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        wakeupButton.setText("Wake up sound");
        wakeupButton.setToolTipText("Quiet perspective can make a wake up sound to draw attention.\nWill sound when events arrive after at least 2 minutes of silence.\nDo not use with frequently updated perspectives.");
        wakeupButton.setSelection(this.vo.getWakeSound() > 0);
        wakeupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!wakeupButton.getSelection()) {
                    LogPerspectiveDlg.this.vo.setWakeSound(Sound.none.ordinal());
                    return;
                }
                SoundDlg dlg = new SoundDlg(LogPerspectiveDlg.this.getShell(), LogPerspectiveDlg.this.vo.getWakeSound());
                if (dlg.open() == 0) {
                    LogPerspectiveDlg.this.vo.setWakeSound(dlg.getSound().ordinal());
                } else {
                    wakeupButton.setSelection(false);
                }
            }
        });
        label = new Label(container, 258);
        label.setText("Filters");
        label.setLayoutData((Object)new GridData(4, 2, true, false, 4, 5));
        this.criteriaComposite = new CriteriaComposite(container, this.vo.getCriteria());
        this.criteriaComposite.setLayoutData(new GridData(4, 4, true, true, 4, 1));
        this.getShell().setMinimumSize(600, 400);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialLocation(Point initialSize) {
        return Display.getCurrent().getCursorLocation();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Log perspective settings");
        newShell.setImage(ImageHolder.getInstance().getImage("icons/filter.gif"));
    }

    protected void okPressed() {
        this.vo.setName(this.perspNameText.getText());
        CriteriaFilter criteria = this.criteriaComposite.getCriteria();
        this.vo.setCriteria(criteria);
        super.okPressed();
    }

    public PerspectiveVO getResult() {
        return this.vo;
    }
}

