/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.model.ChoiceModel;
import com.moonlit.logfaces.client.model.ChoiceModelItem;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ListSelectionDialog
extends Dialog {
    private String title;
    private String image;
    private TableViewer tableViewer;
    private ChoiceModel model;
    private Text filterText;
    private boolean filter = true;
    private Rectangle bounds;
    private ImageHolder images = ImageHolder.getInstance();

    public ListSelectionDialog(Shell shell, String title, String image, ChoiceModel model) {
        super(shell);
        this.title = title;
        this.image = image;
        this.model = model;
        this.bounds = shell.getBounds();
        this.setShellStyle(67696);
    }

    public ListSelectionDialog(String title, String image, ChoiceModel model) {
        super(Application.getShell());
        this.title = title;
        this.image = image;
        this.model = model;
        this.setShellStyle(67696);
    }

    public ListSelectionDialog(String title, String image, ChoiceModel model, boolean filter) {
        this(title, image, model);
        this.filter = filter;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        if (this.filter) {
            Label label = new Label(container, 0);
            label.setText("Filter :");
            this.filterText = new Text(container, 2048);
            this.filterText.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
            this.filterText.addKeyListener((KeyListener)new FilterListener());
        }
        this.tableViewer = new TableViewer(container, 2848);
        this.tableViewer.setContentProvider((IContentProvider)new ThisContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ThisTableLabelProvider());
        this.tableViewer.setInput((Object)this.model);
        this.tableViewer.getTable().addMouseListener((MouseListener)new ClickListener());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 1;
        gd.heightHint = 200;
        this.tableViewer.getTable().setLayoutData((Object)gd);
        this.tableViewer.getTable().setFocus();
        this.model2table();
        return container;
    }

    public void setCentered() {
        Display display = this.getShell().getDisplay();
        int width = display.getClientArea().width;
        int height = display.getClientArea().height;
        this.getShell().setLocation((width - this.getShell().getSize().x) / 2 + display.getClientArea().x, (height - this.getShell().getSize().y) / 2 + display.getClientArea().y);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.model.isSingleSelection()) {
            Button button = this.createButton(parent, 18, "Select all", false);
            button.addSelectionListener((SelectionListener)new SelectListener());
            button = this.createButton(parent, 19, "Deselect all", false);
            button.addSelectionListener((SelectionListener)new DeselectListener());
        }
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        newShell.setImage(this.images.getImage(this.image));
        if (this.bounds != null) {
            newShell.setBounds(this.bounds.x - 10, this.bounds.y - 10, this.bounds.width + 20, this.bounds.height + 20);
        }
    }

    protected Point getInitialLocation(Point initialSize) {
        return this.bounds != null ? initialSize : Display.getCurrent().getCursorLocation();
    }

    protected void okPressed() {
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            ChoiceModelItem item = (ChoiceModelItem)((Object)ti.getData());
            item.setSelected(ti.getChecked());
            ++n2;
        }
        super.okPressed();
    }

    private void model2table() {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.tableViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String name = item.getData().toString();
            item.setChecked(this.model.isItemSelected(name));
            ++n2;
        }
    }

    private void table2model() {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.tableViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            this.model.selectItem(item.getData().toString(), item.getChecked());
            ++n2;
        }
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    class ClickListener
    extends MouseAdapter {
        ClickListener() {
        }

        public void mouseUp(MouseEvent e) {
            TableItem item = ListSelectionDialog.this.tableViewer.getTable().getItem(new Point(e.x, e.y));
            if (item == null) {
                return;
            }
            ListSelectionDialog.this.model.selectItem(item.getData().toString(), item.getChecked());
            if (ListSelectionDialog.this.model.isSingleSelection()) {
                ListSelectionDialog.this.model2table();
                ListSelectionDialog.this.tableViewer.refresh();
            }
        }
    }

    class DeselectListener
    extends SelectionAdapter {
        DeselectListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableItem[] items;
            TableItem[] tableItemArray = items = ListSelectionDialog.this.tableViewer.getTable().getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                item.setChecked(false);
                ++n2;
            }
            ListSelectionDialog.this.table2model();
        }
    }

    class FilterListener
    implements KeyListener {
        FilterListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            ListSelectionDialog.this.model.setFilter(ListSelectionDialog.this.filterText.getText());
            ListSelectionDialog.this.tableViewer.refresh();
            ListSelectionDialog.this.model2table();
        }
    }

    class SelectListener
    extends SelectionAdapter {
        SelectListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableItem[] items;
            TableItem[] tableItemArray = items = ListSelectionDialog.this.tableViewer.getTable().getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                item.setChecked(true);
                ++n2;
            }
            ListSelectionDialog.this.table2model();
        }
    }

    class ThisContentProvider
    implements IStructuredContentProvider {
        ThisContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ListSelectionDialog.this.model.getItems();
        }
    }

    class ThisTableLabelProvider
    implements ITableLabelProvider {
        ThisTableLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return element.toString();
        }
    }
}

