/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.embedded.LicenseManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LicenseDialog
extends Dialog {
    private Text licenseTextField;
    private String licenseInfo;
    private boolean allowInstallation = true;

    public LicenseDialog() {
        super(null);
        this.setShellStyle(68720);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        label.setText("Current license info");
        Link link = new Link(container, 1);
        link.setText("<a href=\"http://www.logfaces.com/\">Request new license</a>");
        link.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        link.setForeground(new Color(null, 0, 0, 255));
        link.setVisible(this.allowInstallation);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Program.launch((String)event.text);
            }
        });
        this.licenseTextField = new Text(container, 2818);
        this.licenseTextField.setEditable(false);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        this.licenseTextField.setLayoutData((Object)gridData);
        new Label(container, 0);
        Button button1 = new Button(container, 0);
        button1.setImage(ImageHolder.getInstance().getButtonImage("/icons/tipoftheday.gif"));
        button1.setText("Install new license");
        button1.setLayoutData((Object)new GridData(2, 2, false, false, 2, 1));
        button1.setVisible(this.allowInstallation);
        button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(LicenseDialog.this.getShell());
                fd.setText("Select logFaces license file");
                fd.setFilterExtensions(new String[]{"*.lic", "*"});
                String fileName = fd.open();
                if (fileName != null) {
                    try {
                        LicenseManager.getInstance().installLicense(fileName);
                        MessageDialog.openInformation(null, (String)"Success", (String)"New license is installed");
                        LicenseDialog.this.displayLicense();
                    }
                    catch (Exception ex) {
                        MessageDialog.openError(null, (String)"Failed", (String)ex.getMessage());
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.displayLicense();
        return container;
    }

    private void displayLicense() {
        if (this.licenseInfo == null) {
            String text = LicenseManager.getInstance().getLicenseContentString();
            this.licenseTextField.setText(text);
            return;
        }
        this.licenseTextField.setText(this.licenseInfo);
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected Point getInitialSize() {
        return new Point(400, 300);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            return;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell newShell) {
        newShell.setImage(ImageHolder.getInstance().getImage("icons/level_debug3.gif"));
        newShell.setText("License information");
        super.configureShell(newShell);
    }

    public void setLicenseInfo(String licenseInfo) {
        this.licenseInfo = licenseInfo;
    }

    public void setAllowInstallation(boolean allowInstallation) {
        this.allowInstallation = allowInstallation;
    }
}

