/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.google.common.collect.Sets;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.utils.Utils;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JiraIssueSubmitDialog
extends Dialog {
    private Text subjectText;
    private Text descriptionText;
    private Combo templateCombo;
    private String summary;
    private String description;
    private String template;
    private IDialogSettings settings;

    public JiraIssueSubmitDialog(Shell parentShell, String subject) {
        super(parentShell);
        this.setShellStyle(67696);
        this.settings = Application.getDialogSettings();
        this.summary = subject;
        this.description = this.settings.get("JiraIssueSubmitDialog.description");
        if (this.description == null) {
            this.description = "";
        }
        this.template = this.settings.get("JiraIssueSubmitDialog.template");
        if (this.template == null) {
            this.template = "";
        }
    }

    protected Control createDialogArea(Composite parent) {
        EnterKeyListener listener = new EnterKeyListener();
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.numColumns = 4;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 64);
        label.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        label.setText("We will create a JIRA issue based on the current template and log events selected. Please enter subject and short description for this issue.");
        label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(3, 2, false, false));
        label.setText("Summary:");
        this.subjectText = new Text(composite, 2048);
        this.subjectText.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        this.subjectText.setText(this.summary);
        this.subjectText.selectAll();
        this.subjectText.forceFocus();
        this.subjectText.addKeyListener((KeyListener)listener);
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(3, 2, false, false));
        label.setText("Description:");
        this.descriptionText = new Text(composite, 2048);
        this.descriptionText.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        this.descriptionText.addKeyListener((KeyListener)listener);
        this.descriptionText.setText(this.description);
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(3, 2, false, false));
        label.setText("Issue template:");
        this.templateCombo = new Combo(composite, 8);
        this.templateCombo.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        this.templateCombo.setVisibleItemCount(20);
        String[] arr = this.settings.getArray("JiraIssueSubmitDialog.templates");
        if (arr != null) {
            String[] stringArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                this.templateCombo.add(t);
                ++n2;
            }
        }
        this.templateCombo.setText(this.template);
        Button addButton = new Button(composite, 0);
        addButton.setText("...");
        addButton.setToolTipText("Select JIRA template file");
        addButton.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraIssueSubmitDialog.this.selectTemplate();
            }
        });
        Button removeButton = new Button(composite, 0);
        removeButton.setText("");
        removeButton.setImage(ImageHolder.getInstance().getButtonImage("icons/trash.gif"));
        removeButton.setToolTipText("Remove selected template file");
        removeButton.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraIssueSubmitDialog.this.templateCombo.remove(JiraIssueSubmitDialog.this.templateCombo.getSelectionIndex());
                JiraIssueSubmitDialog.this.templateCombo.select(JiraIssueSubmitDialog.this.templateCombo.getItemCount() > 0 ? 0 : -1);
                JiraIssueSubmitDialog.this.settings.put("JiraIssueSubmitDialog.templates", JiraIssueSubmitDialog.this.templateCombo.getItems());
            }
        });
        composite.pack();
        return composite;
    }

    private void selectTemplate() {
        FileDialog dialog = new FileDialog(Application.getShell());
        dialog.setText("Select JIRA template file");
        dialog.setFilterExtensions(new String[]{"*.*"});
        dialog.setFilterNames(new String[]{"All files (*.*)"});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        HashSet values = Sets.newHashSet(Arrays.asList(this.templateCombo.getItems()));
        values.add(path);
        this.templateCombo.removeAll();
        for (String t : values) {
            this.templateCombo.add(t);
        }
        this.templateCombo.setText(path);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        button.setText("Create issue");
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setSize(450, 250);
        newShell.setText("Create JIRA issue");
        newShell.setImage(ImageHolder.getInstance().getImage("/icons/jira.png"));
        Point size = newShell.getSize();
        Point location = Utils.getCenterPoint(size);
        newShell.setBounds(new Rectangle(location.x, location.y, size.x, size.y));
    }

    protected void okPressed() {
        this.description = this.descriptionText.getText();
        this.summary = this.subjectText.getText();
        if (this.summary.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Wrong input", (String)"Please specify subject and description");
            return;
        }
        this.template = this.templateCombo.getText();
        if (this.template.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Wrong input", (String)"Please select issue template file");
            return;
        }
        this.settings.put("JiraIssueSubmitDialog.summary", this.summary);
        this.settings.put("JiraIssueSubmitDialog.description", this.description);
        this.settings.put("JiraIssueSubmitDialog.template", this.templateCombo.getText());
        this.settings.put("JiraIssueSubmitDialog.templates", this.templateCombo.getItems());
        super.okPressed();
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTemplate() {
        return this.template;
    }

    class EnterKeyListener
    implements KeyListener {
        EnterKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                JiraIssueSubmitDialog.this.okPressed();
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

