/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.net.ConnectionDetails;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FirstTimeDialog
extends Dialog {
    private Text serverHost;
    private Text serverPort;
    private ConnectionDetails connectionDetails;
    private Image[] images;
    private IEclipsePreferences prefs;

    public FirstTimeDialog(Shell parentShell) {
        super(parentShell);
        this.loadDescriptors();
    }

    protected void configureShell(Shell newShell) {
        String[] imageURLs;
        super.configureShell(newShell);
        newShell.setText("Connect to logFaces Server");
        IProduct product = Platform.getProduct();
        if (product != null && (imageURLs = FirstTimeDialog.parseCSL(product.getProperty("windowImages"))) != null && imageURLs.length > 0) {
            this.images = new Image[imageURLs.length];
            int i = 0;
            while (i < imageURLs.length) {
                String url = imageURLs[i];
                ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)product.getDefiningBundle().getSymbolicName(), (String)url);
                this.images[i] = descriptor.createImage(true);
                ++i;
            }
            newShell.setImages(this.images);
        }
    }

    public static String[] parseCSL(String csl) {
        if (csl == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(csl, ",");
        ArrayList<String> array = new ArrayList<String>(10);
        while (tokens.hasMoreTokens()) {
            array.add(tokens.nextToken().trim());
        }
        return array.toArray(new String[array.size()]);
    }

    public boolean close() {
        if (this.images != null) {
            int i = 0;
            while (i < this.images.length) {
                this.images[i].dispose();
                ++i;
            }
        }
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        Label hostLabel = new Label(composite, 0);
        hostLabel.setText("&Server host:");
        hostLabel.setLayoutData((Object)new GridData(3, 2, false, false));
        this.serverHost = new Text(composite, 2048);
        this.serverHost.setLayoutData((Object)new GridData(4, 4, true, false));
        Label portLabel = new Label(composite, 0);
        portLabel.setText("&Server port:");
        portLabel.setLayoutData((Object)new GridData(3, 2, false, false));
        this.serverPort = new Text(composite, 2048);
        this.serverPort.setLayoutData((Object)new GridData(4, 4, true, false));
        this.serverHost.setText(this.connectionDetails.getLfsHost());
        this.serverPort.setText(Integer.toString(this.connectionDetails.getLfsPort()));
        final Button autoLogin = new Button(composite, 32);
        autoLogin.setText("Use these settings automatically and don't ask me again");
        autoLogin.setLayoutData((Object)new GridData(1, 0x1000000, true, true, 2, 10));
        autoLogin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FirstTimeDialog.this.connectionDetails.setAutoLogin(autoLogin.getSelection());
            }
        });
        boolean auto_login = this.prefs.getBoolean("lfs_auto_connect", false);
        autoLogin.setSelection(auto_login);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "&Connect", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        String hostName = this.serverHost.getText();
        String portNum = this.serverPort.getText();
        if (hostName.length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Invalid host name", (String)"Host name field must not be blank.");
            return;
        }
        if (!this.validatePortNumber(portNum)) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Invalid port number", (String)"Port number field must be positive numeric value in range of 1-65000");
            return;
        }
        this.connectionDetails.setLfsHost(hostName);
        this.connectionDetails.setLfsPort(Integer.parseInt(portNum));
        this.connectionDetails.save();
        super.okPressed();
    }

    private void loadDescriptors() {
        this.prefs = ConfigurationScope.INSTANCE.getNode("com.moonlit.logfaces.client.plugin");
        this.connectionDetails = new ConnectionDetails(this.prefs);
    }

    public ConnectionDetails getConnectionDetails() {
        return this.connectionDetails;
    }

    private boolean validatePortNumber(String text) {
        try {
            int num = Integer.parseInt(text);
            if (num > 0 && num < 65000) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

