/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.editors.Searchable;
import com.moonlit.logfaces.client.model.SearchOptions;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FindDialog
extends Dialog
implements IPartListener {
    private static FindDialog instance;
    private IDialogSettings settings;
    private Searchable target;
    private Text input;
    private Label notice;
    private SearchOptions options = new SearchOptions();
    private Button filterButton;
    private Button annotateButton;
    private ImageHolder images = ImageHolder.getInstance();

    public static FindDialog getInstance() {
        if (instance == null) {
            instance = new FindDialog();
        }
        return instance;
    }

    public void activate(Searchable target) {
        this.target = target;
        this.open();
        if (target != null) {
            target.setActive(true);
        }
        this.updateControls();
    }

    public void activate(IEditorPart part) {
        if (part == null) {
            return;
        }
        if (part instanceof LogView) {
            this.target = ((LogView)part).getSearchable();
        } else if (part instanceof Searchable) {
            this.target = (Searchable)part;
        } else {
            return;
        }
        this.open();
        if (this.target != null) {
            this.target.setActive(true);
        }
        this.updateControls();
    }

    private FindDialog() {
        super(Application.getShell());
        this.setShellStyle(2160);
        this.setBlockOnOpen(false);
        this.settings = Application.getDialogSettings();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        window.getPartService().addPartListener((IPartListener)this);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 10;
        gridLayout.marginLeft = 10;
        gridLayout.marginRight = 10;
        gridLayout.numColumns = 1;
        container.setLayout((Layout)gridLayout);
        Composite top = new Composite(container, 0);
        top.setLayout((Layout)new GridLayout(1, true));
        top.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.input = new Text(top, 2048);
        this.input.setLayoutData((Object)new GridData(4, 2, true, true, 1, 1));
        String temp = this.settings.get("FindDialog.input");
        this.input.setText(temp != null ? temp : "");
        this.input.selectAll();
        this.input.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode != 13 && e.keyCode != 0x1000050) {
                    return;
                }
                if ((e.stateMask & 0x20000) == 131072) {
                    FindDialog.this.findPrev();
                } else {
                    FindDialog.this.findNext();
                }
            }
        });
        this.notice = new Label(container, 0);
        this.notice.setForeground(Display.getCurrent().getSystemColor(3));
        this.notice.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.pack();
        return container;
    }

    public void setText(String text) {
        this.input.setText(text != null ? text : "");
        this.input.selectAll();
    }

    private void updateControls() {
        if (this.target != null) {
            if (!this.filterButton.isDisposed()) {
                this.filterButton.setEnabled(this.target.canFindAnnotate());
                this.filterButton.setText(this.target.isFiltered() ? "Un-Filter" : "Filter");
                this.filterButton.setImage(this.images.getButtonImage(this.target.isFiltered() ? "icons/eclipse3_clear.gif" : "icons/filter.gif"));
            }
            if (!this.annotateButton.isDisposed()) {
                this.annotateButton.setEnabled(this.target.canFindAnnotate());
                this.annotateButton.setText(this.target.isMarked() ? "De-Annotate" : "Annotate");
                this.annotateButton.setImage(this.images.getButtonImage(this.target.isMarked() ? "icons/eclipse3_clear.gif" : "icons/bookmark.gif"));
            }
            if (!this.notice.isDisposed()) {
                this.notice.setText("");
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 256, "Find next", false);
        button.setToolTipText("Find next occurence (Enter)");
        button.setImage(this.images.getButtonImage("icons/feed.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindDialog.this.findNext();
            }
        });
        button = this.createButton(parent, 256, "Find previous", false);
        button.setToolTipText("Find previous occurence (Shift+Enter)");
        button.setImage(this.images.getButtonImage("/icons/select_prev.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindDialog.this.findPrev();
            }
        });
        this.filterButton = this.createButton(parent, 256, "Filter", false);
        this.filterButton.setToolTipText("Display only items matching the search criteria");
        this.filterButton.setImage(this.images.getButtonImage("icons/filter.gif"));
        this.filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindDialog.this.filter();
            }
        });
        this.annotateButton = this.createButton(parent, 256, "Annotate", false);
        this.annotateButton.setToolTipText("Annotate items matching the search criteria");
        this.annotateButton.setImage(this.images.getButtonImage("icons/bookmark.gif"));
        this.annotateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindDialog.this.annotate();
            }
        });
        GridData gd = (GridData)button.getLayoutData();
        gd.widthHint = 110;
    }

    protected Point getInitialLocation(Point initialSize) {
        return super.getInitialLocation(initialSize);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Find...");
        newShell.setImage(ImageHolder.getInstance().getImage("icons/feed.gif"));
        try {
            newShell.setSize(this.settings.getInt("FindDialog.x"), this.settings.getInt("FindDialog.y"));
            newShell.setLocation(this.settings.getInt("FindDialog.lx"), this.settings.getInt("FindDialog.ly"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean close() {
        this.settings.put("FindDialog.input", this.input.getText());
        Point size = this.getShell().getSize();
        Point location = this.getShell().getLocation();
        this.settings.put("FindDialog.x", size.x);
        this.settings.put("FindDialog.y", size.y);
        this.settings.put("FindDialog.lx", location.x);
        this.settings.put("FindDialog.ly", location.y);
        if (this.target != null) {
            this.target.unfilter();
            this.target.setActive(false);
        }
        return super.close();
    }

    protected SearchOptions getOptions() {
        this.options.setSearchText(this.input.getText());
        return this.options;
    }

    protected void findNext() {
        if (this.target == null) {
            return;
        }
        String note = this.target.findNext(this.getOptions()) ? "" : "Not found";
        this.notice.setText(note);
    }

    protected void findPrev() {
        if (this.target == null) {
            return;
        }
        String note = this.target.findPrev(this.getOptions()) ? "" : "Not found";
        this.notice.setText(note);
    }

    protected void filter() {
        if (this.target == null) {
            return;
        }
        String note = this.target.findAndFilter(this.getOptions()) ? "" : "Not found";
        this.notice.setText(note);
        this.updateControls();
    }

    protected void annotate() {
        if (this.target == null) {
            return;
        }
        String note = this.target.findAndMark(this.getOptions()) ? "" : "Not found";
        this.notice.setText(note);
        this.updateControls();
    }

    public void partActivated(IWorkbenchPart part) {
        this.updateControls();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.target = part instanceof Searchable ? (Searchable)part : (part instanceof LogView ? ((LogView)part).getSearchable() : null);
        this.updateControls();
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

