/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.types.TimeRange;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DateTimeRangeChooser
extends Dialog {
    private String title = "Select time range";
    private DateTime date;
    private DateTime date2;
    private DateTime time;
    private DateTime time2;
    private Calendar calendar = Calendar.getInstance();
    private Calendar calendar2;
    private boolean timeVisible = true;

    public DateTimeRangeChooser(Shell shell, TimeRange range) {
        this(shell, range.getTime(true), range.getTime(false), TimeZone.getDefault());
    }

    public DateTimeRangeChooser(Shell shell, long time, long time2, TimeZone timeZone) {
        super(shell);
        this.calendar.setTimeZone(timeZone);
        this.calendar.setTime(new Date(time));
        this.calendar2 = Calendar.getInstance();
        this.calendar2.setTimeZone(timeZone);
        this.calendar2.setTime(new Date(time2));
        this.setShellStyle(67680);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        Label label = new Label(container, 0);
        label.setText("Starting date time");
        label = new Label(container, 0);
        label.setText("Ending date time");
        this.date = new DateTime(container, 3072);
        this.date2 = new DateTime(container, 3072);
        this.time = new DateTime(container, 0x10000080);
        this.time2 = new DateTime(container, 0x10000080);
        this.date.setYear(this.calendar.get(1));
        this.date.setMonth(this.calendar.get(2));
        this.date.setDay(this.calendar.get(5));
        this.date2.setYear(this.calendar2.get(1));
        this.date2.setMonth(this.calendar2.get(2));
        this.date2.setDay(this.calendar2.get(5));
        this.calendar.set(14, 0);
        this.calendar2.set(14, 0);
        if (!this.timeVisible) {
            this.calendar.set(11, 0);
            this.calendar.set(12, 0);
            this.calendar.set(13, 0);
            this.calendar2.set(11, 0);
            this.calendar2.set(12, 0);
            this.calendar2.set(13, 0);
        }
        this.time.setVisible(this.timeVisible);
        this.time.setHours(this.calendar.get(11));
        this.time.setMinutes(this.calendar.get(12));
        this.time.setSeconds(this.calendar.get(13));
        this.time2.setVisible(this.timeVisible);
        this.time2.setHours(this.calendar2.get(11));
        this.time2.setMinutes(this.calendar2.get(12));
        this.time2.setSeconds(this.calendar2.get(13));
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        newShell.setImage(ImageHolder.getInstance().getImage("icons/lf16.png"));
    }

    protected Point getInitialLocation(Point initialSize) {
        return Display.getCurrent().getCursorLocation();
    }

    protected void okPressed() {
        this.calendar.set(1, this.date.getYear());
        this.calendar.set(2, this.date.getMonth());
        this.calendar.set(5, this.date.getDay());
        this.calendar.set(11, this.time.getHours());
        this.calendar.set(12, this.time.getMinutes());
        this.calendar.set(13, this.time.getSeconds());
        this.calendar.set(14, 0);
        this.calendar2.set(1, this.date2.getYear());
        this.calendar2.set(2, this.date2.getMonth());
        this.calendar2.set(5, this.date2.getDay());
        this.calendar2.set(11, this.time2.getHours());
        this.calendar2.set(12, this.time2.getMinutes());
        this.calendar2.set(13, this.time2.getSeconds());
        this.calendar2.set(14, 0);
        if (this.getTime() > this.getTime2()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Incorrect range", (String)"Starting date time must be earler than ending.");
            return;
        }
        super.okPressed();
    }

    public void setTimeVisible(boolean visible) {
        this.timeVisible = visible;
    }

    public long getTime() {
        return this.calendar.getTimeInMillis();
    }

    public long getTime2() {
        if (!this.timeVisible) {
            return this.calendar2.getTimeInMillis() + 86400000L;
        }
        return this.calendar2.getTimeInMillis();
    }
}

