/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.types.TimeRange;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DateTimeChooser
extends Dialog {
    private String title = "Select date and time";
    private DateTime date;
    private DateTime time;
    private Calendar calendar;
    private boolean timeVisible = true;
    private final SimpleDateFormat dtf = new SimpleDateFormat("dd MMMMM HH:mm");

    public DateTimeChooser(Shell shell, TimeRange range) {
        this(shell, range.getTime(true), TimeZone.getDefault());
    }

    public DateTimeChooser(Shell shell, long time, TimeZone timeZone) {
        super(shell);
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeZone(timeZone);
        this.calendar.setTime(new Date(time));
        this.dtf.setTimeZone(timeZone);
        this.setShellStyle(67680);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        container.setLayout((Layout)gridLayout);
        this.date = new DateTime(container, 3072);
        this.time = new DateTime(container, 32896);
        this.date.setYear(this.calendar.get(1));
        this.date.setMonth(this.calendar.get(2));
        this.date.setDay(this.calendar.get(5));
        if (!this.timeVisible) {
            this.calendar.set(11, 0);
            this.calendar.set(12, 0);
            this.calendar.set(13, 0);
            this.calendar.set(14, 0);
        }
        this.time.setVisible(this.timeVisible);
        this.time.setHours(this.calendar.get(11));
        this.time.setMinutes(this.calendar.get(12));
        this.time.setSeconds(13);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        newShell.setImage(ImageHolder.getInstance().getImage("icons/lf16.png"));
    }

    protected Point getInitialLocation(Point initialSize) {
        return Display.getCurrent().getCursorLocation();
    }

    protected void okPressed() {
        this.calendar.set(1, this.date.getYear());
        this.calendar.set(2, this.date.getMonth());
        this.calendar.set(5, this.date.getDay());
        this.calendar.set(11, this.time.getHours());
        this.calendar.set(12, this.time.getMinutes());
        System.out.println("Calendar date selected " + this.dtf.format(new Date(this.calendar.getTimeInMillis())));
        super.okPressed();
    }

    public void setTimeVisible(boolean visible) {
        this.timeVisible = visible;
    }

    public long getTime() {
        return this.calendar.getTimeInMillis();
    }
}

