/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.widgets.CriteriaComposite;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CriteriaDialog
extends Dialog {
    private CriteriaComposite criteriaComposite;
    private QueryVO currentQuery;

    public CriteriaDialog(Shell parent, QueryVO query, boolean displayName) {
        super(parent);
        this.currentQuery = query;
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        container.setLayout((Layout)gridLayout);
        this.criteriaComposite = new CriteriaComposite(container, this.currentQuery);
        this.criteriaComposite.setLayoutData(new GridData(4, 4, true, true, 4, 1));
        this.criteriaComposite.setFocus();
        this.getShell().setMinimumSize(600, 350);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialLocation(Point initialSize) {
        return Display.getCurrent().getCursorLocation();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Query");
        newShell.setImage(ImageHolder.getInstance().getImage("icons/query.gif"));
    }

    protected void okPressed() {
        CriteriaFilter criteria = this.criteriaComposite.getCriteria();
        this.currentQuery.setCriteria(criteria);
        this.currentQuery.setEscapeSql(this.criteriaComposite.isEscape());
        super.okPressed();
    }

    public QueryVO getResult() {
        return this.currentQuery;
    }
}

