/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.model.CounterModel;
import com.moonlit.logfaces.client.model.CountersModel;
import com.moonlit.logfaces.client.model.PerspectiveVO;
import com.moonlit.logfaces.client.prefs.PersistentCounter;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.client.widgets.CriteriaComposite;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CountersSetupDialog
extends Dialog {
    private IWorkbenchPartSite site;
    private TableViewer counters;
    private CriteriaComposite criteriaComposite;
    private CounterModel currentCounter;
    private Label counterHeader;
    private ImageHolder images = ImageHolder.getInstance();
    private Shell shell;

    public CountersSetupDialog(IWorkbenchPartSite site) {
        super(site.getShell());
        this.setShellStyle(67696);
        this.site = site;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        container.setLayout((Layout)gridLayout);
        Button button = new Button(container, 0);
        button.setToolTipText("Add new counter...");
        button.setImage(this.images.getImage("icons/add.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new AddCounterAction().run();
            }
        });
        button = new Button(container, 0);
        button.setToolTipText("Remove selected counters");
        button.setImage(this.images.getImage("icons/close.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new RemoveCounterAction().run();
            }
        });
        button = new Button(container, 0);
        button.setToolTipText("Rename selected counter");
        button.setImage(this.images.getImage("icons/eclipse3_edit.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new RenameCounterAction().run();
            }
        });
        button = new Button(container, 0);
        button.setImage(this.images.getImage("/icons/select_prev.gif"));
        button.setToolTipText("Move up");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new MoveupCounterAction().run();
            }
        });
        button = new Button(container, 0);
        button.setImage(this.images.getImage("/icons/select_next.gif"));
        button.setToolTipText("Move down");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new MovedownCounterAction().run();
            }
        });
        this.counterHeader = new Label(container, 0);
        this.counterHeader.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.counterHeader.setText("Filters :");
        this.counters = new TableViewer(container, 770);
        GridData gd = new GridData(4, 4, true, true, 5, 1);
        gd.widthHint = 150;
        this.counters.getTable().setLayoutData((Object)gd);
        this.counters.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        this.counters.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.counters.setInput((Object)CountersModel.getInstance());
        this.counters.addSelectionChangedListener((ISelectionChangedListener)new CounterSelectedListener());
        this.criteriaComposite = new CriteriaComposite(container);
        this.criteriaComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.criteriaComposite.setVisible(false);
        this.currentCounter = CountersModel.getInstance().getFirst();
        if (this.currentCounter != null) {
            this.counterHeader.setText(this.currentCounter.getName() + " :");
            this.criteriaComposite.setCriteria(this.currentCounter.getSettings().getCriteria());
            this.criteriaComposite.setVisible(true);
            this.counters.getTable().setSelection(0);
        } else {
            this.counterHeader.setVisible(false);
        }
        this.getShell().setMinimumSize(600, 450);
        return container;
    }

    protected void okPressed() {
        this.criteria2counter();
        super.okPressed();
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CountersSetupDialog.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.counters.getControl());
        this.counters.getControl().setMenu(menu);
        this.site.registerContextMenu(menuMgr, (ISelectionProvider)this.counters);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IAction)new AddCounterAction());
        manager.add((IAction)new MoveupCounterAction());
        manager.add((IAction)new MovedownCounterAction());
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IAction)new RenameCounterAction());
        manager.add((IAction)new RemoveCounterAction());
        manager.add((IAction)new RemoveAllCountersAction());
    }

    protected void criteria2counter() {
        if (this.currentCounter != null) {
            this.currentCounter.getSettings().setCriteria(this.criteriaComposite.getCriteria());
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Dashboard counters");
        newShell.setImage(ImageHolder.getInstance().getImage("icons/dashboard.gif"));
        this.shell = newShell;
    }

    protected Point getInitialLocation(Point initialSize) {
        return Utils.getCenterPoint(initialSize);
    }

    class AddCounterAction
    extends Action {
        public AddCounterAction() {
            this.setText("Add new counter");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/add.gif"));
        }

        public void run() {
            InputDialog input = new InputDialog(CountersSetupDialog.this.shell, "New dashboard counter", "Monitoring counter will be shown in the dashboard chart as a number of occurencies of events which match the filtering you will specify for it.\n\nPlease enter a name for this counter:", "counter-" + PersistentCounter.getInstance().getCounter(), null);
            if (input.open() != 0) {
                return;
            }
            if (input.getValue().length() == 0) {
                return;
            }
            CountersSetupDialog.this.criteria2counter();
            PerspectiveVO perspective = new PerspectiveVO();
            perspective.setName(input.getValue());
            CountersSetupDialog.this.currentCounter = CountersModel.getInstance().add(perspective);
            CountersSetupDialog.this.criteriaComposite.setCriteria(CountersSetupDialog.this.currentCounter.getSettings().getCriteria());
            CountersSetupDialog.this.counters.refresh();
            CountersSetupDialog.this.counters.setSelection((ISelection)new StructuredSelection((Object)CountersSetupDialog.this.currentCounter));
            CountersSetupDialog.this.counters.getTable().select(CountersSetupDialog.this.counters.getTable().getItems().length - 1);
            CountersSetupDialog.this.counters.refresh();
            CountersSetupDialog.this.counterHeader.setText(perspective.getName() + " :");
            CountersSetupDialog.this.counterHeader.setVisible(true);
            CountersSetupDialog.this.criteriaComposite.setCriteria(perspective.getCriteria());
            CountersSetupDialog.this.criteriaComposite.setVisible(true);
        }
    }

    class CounterSelectedListener
    implements ISelectionChangedListener {
        CounterSelectedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            CounterModel selected = (CounterModel)((Object)selection.getFirstElement());
            if (selected != null) {
                CountersSetupDialog.this.criteria2counter();
                CountersSetupDialog.this.criteriaComposite.setCriteria(selected.getSettings().getCriteria());
                CountersSetupDialog.this.counterHeader.setVisible(true);
                CountersSetupDialog.this.criteriaComposite.setVisible(true);
                CountersSetupDialog.this.counterHeader.setText(selected.getName() + " :");
            }
            CountersSetupDialog.this.currentCounter = selected;
        }
    }

    class MovedownCounterAction
    extends Action {
        public MovedownCounterAction() {
            this.setText("Move down");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/select_next.gif"));
        }

        public void run() {
            int index = CountersSetupDialog.this.counters.getTable().getSelectionIndex();
            if (index != -1) {
                CountersModel.getInstance().moveDown(index);
                CountersSetupDialog.this.counters.refresh();
            }
        }
    }

    class MoveupCounterAction
    extends Action {
        public MoveupCounterAction() {
            this.setText("Move up");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/select_prev.gif"));
        }

        public void run() {
            int index = CountersSetupDialog.this.counters.getTable().getSelectionIndex();
            if (index != -1) {
                CountersModel.getInstance().moveUp(index);
                CountersSetupDialog.this.counters.refresh();
            }
        }
    }

    class RemoveAllCountersAction
    extends Action {
        public RemoveAllCountersAction() {
            this.setText("Remove ALL counters");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/close.gif"));
        }

        public void run() {
            CountersModel.getInstance().removeAll();
            CountersSetupDialog.this.counters.refresh();
            CountersSetupDialog.this.counterHeader.setVisible(false);
            CountersSetupDialog.this.criteriaComposite.setVisible(false);
        }
    }

    class RemoveCounterAction
    extends Action {
        public RemoveCounterAction() {
            this.setText("Remove counter");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/eclipse3_remove.gif"));
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)CountersSetupDialog.this.counters.getSelection();
            Object[] items = selection.toArray();
            int i = 0;
            while (i < items.length) {
                CounterModel counter = (CounterModel)((Object)items[i]);
                CountersModel.getInstance().remove(counter);
                CountersSetupDialog.this.counters.refresh();
                CountersSetupDialog.this.counterHeader.setVisible(false);
                CountersSetupDialog.this.criteriaComposite.setVisible(false);
                ++i;
            }
        }
    }

    class RenameCounterAction
    extends Action {
        public RenameCounterAction() {
            this.setText("Rename");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/eclipse3_edit.gif"));
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)CountersSetupDialog.this.counters.getSelection();
            Object[] items = selection.toArray();
            if (items.length != 1) {
                return;
            }
            CounterModel model = (CounterModel)((Object)items[0]);
            InputDialog input = new InputDialog(CountersSetupDialog.this.shell, "Rename counter", "Please specify new name for this counter. This name will appear in the dashboard chart.", model.getName(), null);
            if (input.open() != 0) {
                return;
            }
            if (input.getValue().length() == 0) {
                return;
            }
            model.setName(input.getValue());
            CountersSetupDialog.this.counters.refresh();
        }
    }
}

