/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.Workspace;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.dialogs.ConnectionAdapter;
import com.moonlit.logfaces.client.dialogs.ConnectionComposite2;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.net.ConnectionDetails;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Utils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.StartupThreading;

public class ConnectionDialog2
extends Dialog
implements ConnectionAdapter {
    private ConnectionDetails connectionDetails;
    private WorkspaceHolder workspaces = WorkspaceHolder.getInstance();
    private Workspace workspace;
    private ConnectionComposite2 connectionComposite;
    private Image[] images;
    private Composite container;
    private ThisMonitorPart monitor;
    private Image background;
    private Logger log = LogManager.getLogger(this.getClass());

    public ConnectionDialog2() {
        this(null, new ConnectionDetails());
    }

    public ConnectionDialog2(Shell parent, ConnectionDetails connectionDetails) {
        super(parent);
        this.connectionDetails = connectionDetails;
        this.setShellStyle(65536);
    }

    protected void configureShell(final Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("logFaces");
        newShell.setSize(Util.isLinux() ? new Point(550, 350) : new Point(460, 312));
        Monitor primary = newShell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = newShell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        newShell.setLocation(x, y);
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent shellevent) {
                newShell.removeShellListener((ShellListener)this);
                if (ConnectionDialog2.this.connectionDetails.isAutoLogin() || ConnectionDialog2.this.workspace != null) {
                    ConnectionDialog2.this.log.info("performing automatic connection");
                    ConnectionDialog2.this.activate();
                }
            }
        });
        this.log.info("Connection dialog: {}, zoom: {}, scale: {}", (Object)newShell.getSize(), (Object)DPIUtil.getDeviceZoom(), (Object)System.getProperty("swt.autoScale", "???"));
    }

    public boolean close() {
        if (this.images != null) {
            int i = 0;
            while (i < this.images.length) {
                this.images[i].dispose();
                ++i;
            }
        }
        if (this.background != null) {
            this.background.dispose();
        }
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 0;
    }

    protected Control createDialogArea(Composite parent) {
        this.container = (Composite)super.createDialogArea(parent);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.container.setBackgroundMode(2);
        this.container.setBackground(EventStyles.BG_INFO);
        this.container.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                Rectangle rect = ConnectionDialog2.this.container.getBounds();
                Rectangle rect1 = new Rectangle(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
                e.gc.setLineStyle(1);
                e.gc.setLineWidth(2);
                e.gc.setForeground(EventStyles.BG_SELECTION);
                e.gc.drawRectangle(rect1);
            }
        });
        Image image = ImageHolder.getInstance().getImage("icons/splash.png");
        Point size = this.getShell().getSize();
        this.background = Utils.resizeImage(image, size.x, size.y);
        this.container.setBackgroundImage(this.background);
        if (!this.connectionDetails.isAutoLogin()) {
            this.displayConnectionUI();
        }
        return this.container;
    }

    private void displayConnectionUI() {
        try {
            this.dispose();
            this.connectionComposite = new ConnectionComposite2(this.container, this.connectionDetails, this);
            this.connectionComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
            this.container.layout(true, true);
            this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ConnectionDialog2.this.connectionComposite.isDisposed()) {
                        ConnectionDialog2.this.connectionComposite.forceFocus();
                    }
                }
            });
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Internal error, see log file", (String)e.getMessage());
        }
    }

    private boolean displayProgressUI() {
        try {
            this.dispose();
            Composite parent = new Composite(this.container, 0x40040000);
            Point size = this.container.getSize();
            parent.setBounds(new Rectangle(0, 0, size.x, size.y));
            this.monitor = new ThisMonitorPart(parent);
            this.monitor.setSize(size);
            this.monitor.getProgressText().setBounds(new Rectangle(150, size.y / 2, 300, 50));
            this.monitor.setBackgroundMode(2);
            this.container.layout(true, true);
            return true;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Internal error, see log file", (String)e.getMessage());
            return false;
        }
    }

    private void dispose() {
        if (this.monitor != null) {
            this.monitor.getParent().dispose();
            this.monitor.dispose();
        }
        if (this.connectionComposite != null) {
            this.connectionComposite.dispose();
        }
        this.connectionComposite = null;
        this.monitor = null;
    }

    @Override
    public void activate() {
        this.log.info("activating connection");
        if (!this.displayProgressUI()) {
            return;
        }
        this.monitor.subTask("initializing application");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ConnectionDialog2.this.workspace != null) {
                        ConnectionDialog2.this.workspaces.setCurrentWorkspace(ConnectionDialog2.this.workspace);
                    } else {
                        Workspace ws = ConnectionDialog2.this.workspaces.getWorkspace(ConnectionDialog2.this.connectionDetails.getCurrentWorkspace());
                        ws.setServerHost(ConnectionDialog2.this.connectionDetails.getLfsHost());
                        ws.setServerPort(ConnectionDialog2.this.connectionDetails.getLfsPort());
                        ws.setSsl(ConnectionDialog2.this.connectionDetails.isSsl());
                        ConnectionDialog2.this.workspaces.setCurrentWorkspace(ws);
                    }
                    LfsConnector.getInstance().connect((IProgressMonitor)ConnectionDialog2.this.monitor);
                    ConnectionDialog2.this.invokeLater(() -> ConnectionDialog2.this.okPressed());
                }
                catch (Throwable e) {
                    ConnectionDialog2.this.invokeLater(() -> {
                        MessageDialog.openError((Shell)ConnectionDialog2.this.getShell(), (String)"Connection failed", (String)e.getMessage());
                        ConnectionDialog2.this.displayConnectionUI();
                    });
                }
            }
        }).start();
    }

    @Override
    public void cancel() {
        this.cancelPressed();
    }

    private void updateUI(final Runnable r) {
        try {
            if (this.container.isDisposed()) {
                return;
            }
            Display display = this.container.getDisplay();
            if (Thread.currentThread() == display.getThread()) {
                r.run();
                return;
            }
            display.asyncExec((Runnable)new StartupThreading.StartupRunnable(){

                public void runWithException() throws Throwable {
                    r.run();
                }
            });
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
        }
    }

    private void invokeLater(final Runnable r) {
        if (this.container.isDisposed()) {
            return;
        }
        this.container.getDisplay().asyncExec((Runnable)new StartupThreading.StartupRunnable(){

            public void runWithException() throws Throwable {
                r.run();
            }
        });
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    class ThisMonitorPart
    extends ProgressMonitorPart {
        public ThisMonitorPart(Composite parent) {
            super(parent, null);
            this.fProgressIndicator.setVisible(false);
            this.setLayout(null);
        }

        public ProgressIndicator getProgressIndicator() {
            return this.fProgressIndicator;
        }

        public Label getProgressText() {
            return this.fLabel;
        }

        public void subTask(String name) {
            Utils.sleep(50);
            this.fSubTaskName = name;
            this.updateLabel();
        }

        public void beginTask(final String name, final int totalWork) {
            ConnectionDialog2.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (ThisMonitorPart.this.isDisposed()) {
                        return;
                    }
                    ThisMonitorPart.super.beginTask(name, totalWork);
                }
            });
        }

        public void done() {
            ConnectionDialog2.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (ThisMonitorPart.this.isDisposed()) {
                        return;
                    }
                    ((ThisMonitorPart)ThisMonitorPart.this).ConnectionDialog2.this.log.info("ThisMonitorPart done");
                    Utils.sleep(500);
                    ThisMonitorPart.super.done();
                }
            });
        }

        public void internalWorked(final double work) {
            ConnectionDialog2.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (ThisMonitorPart.this.isDisposed()) {
                        return;
                    }
                    ThisMonitorPart.super.internalWorked(work);
                }
            });
        }

        public void setFont(final Font font) {
            ConnectionDialog2.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (ThisMonitorPart.this.isDisposed()) {
                        return;
                    }
                    ThisMonitorPart.super.setFont(font);
                }
            });
        }

        protected void updateLabel() {
            ConnectionDialog2.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (ThisMonitorPart.this.isDisposed()) {
                        return;
                    }
                    ThisMonitorPart.super.updateLabel();
                }
            });
        }

        public void playLabelText() {
            this.fLabel.setText(this.fLabel.getText() + " *");
            this.fLabel.update();
        }
    }
}

