/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.dialogs.ConnectionAdapter;
import com.moonlit.logfaces.client.dialogs.ConnectionComposite;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.net.ConnectionDetails;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ConnectionDialog
extends Dialog
implements ConnectionAdapter {
    private ConnectionDetails connectionDetails;
    private ConnectionComposite composite;
    private Image[] images;

    public ConnectionDialog(Shell parentShell, ConnectionDetails connectionDetails) {
        super(parentShell);
        this.connectionDetails = connectionDetails;
        this.setShellStyle(67584);
    }

    protected Point getInitialLocation(Point initialSize) {
        return this.getParentShell().getLocation();
    }

    protected void configureShell(Shell newShell) {
        String[] imageURLs;
        super.configureShell(newShell);
        newShell.setText("Connect to logFaces Server");
        newShell.setMinimumSize(Util.isLinux() ? 550 : 500, 310);
        newShell.setSize(this.getParentShell().getSize().x + 8, this.getParentShell().getSize().y + 10);
        Point location = this.getParentShell().getLocation();
        newShell.setLocation(location.x - 4, location.y - 4);
        IProduct product = Platform.getProduct();
        if (product != null && (imageURLs = ConnectionDialog.parseCSL(product.getProperty("windowImages"))) != null && imageURLs.length > 0) {
            this.images = new Image[imageURLs.length];
            int i = 0;
            while (i < imageURLs.length) {
                String url = imageURLs[i];
                ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)product.getDefiningBundle().getSymbolicName(), (String)url);
                this.images[i] = descriptor.createImage(true);
                ++i;
            }
            newShell.setImages(this.images);
        }
    }

    public static String[] parseCSL(String csl) {
        if (csl == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(csl, ",");
        ArrayList<String> array = new ArrayList<String>(10);
        while (tokens.hasMoreTokens()) {
            array.add(tokens.nextToken().trim());
        }
        return array.toArray(new String[array.size()]);
    }

    public boolean close() {
        if (this.images != null) {
            int i = 0;
            while (i < this.images.length) {
                this.images[i].dispose();
                ++i;
            }
        }
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 0;
    }

    protected Control createDialogArea(Composite parent) {
        final Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setBackgroundMode(2);
        container.setBackground(EventStyles.BG_INFO);
        container.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                e.gc.setBackground(EventStyles.BG_SELECTION);
                Rectangle rect = container.getBounds();
                Rectangle rect1 = new Rectangle(rect.x - 1, rect.y - 1, rect.width, rect.height);
                e.gc.setLineStyle(1);
                e.gc.fillRectangle(rect1);
            }
        });
        this.composite = new ConnectionComposite(container, this.connectionDetails, (ConnectionAdapter)this);
        this.composite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        return container;
    }

    public ConnectionDetails getConnectionDetails() {
        return this.connectionDetails;
    }

    @Override
    public void activate() {
        super.okPressed();
    }

    @Override
    public void cancel() {
        System.exit(0);
    }
}

