/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.Workspace;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.dialogs.ConnectionAdapter;
import com.moonlit.logfaces.client.jobs.CertificateInstallerJob;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.net.ConnectionDetails;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.util.Revision;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConnectionComposite2
extends Composite {
    private IEclipsePreferences prefs;
    private ConnectionDetails connectionDetails;
    private boolean serverMode;
    private Text serverPort;
    private Text udpPort;
    private Text udpSysPort;
    private Text tcpPort;
    private Text tcpSysPort;
    private Combo serverHost;
    private Combo workspace;
    private Button tcpEnabled;
    private Button tcpSysEnabled;
    private Button udpEnabled;
    private Button udpSysEnabled;
    private Button serverSsl;
    private Button okButton;
    private Button cancelButton;
    private Link caLink;
    private Label hostLabel;
    private Label workspaceLabel;
    private Composite content;
    private Composite modeComposite;
    private Composite clientPanel;
    private Composite serverPanel;
    private ThisKeyListener keyListener = new ThisKeyListener();
    private Shell parentShell;
    private WorkspaceHolder workspaces = WorkspaceHolder.getInstance();
    private ConnectionAdapter caller;
    private Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());

    public ConnectionComposite2(Composite parent, ConnectionDetails details, ConnectionAdapter caller) {
        super(parent, 0x40040000);
        this.caller = caller;
        this.parentShell = this.getParent().getShell();
        this.prefs = Application.getPrefs();
        this.connectionDetails = details;
        if (Util.isMac() && Revision.parse((String)System.getProperty("os.version", "0.0.0.0")).getMajor() == 14) {
            parent.setBackgroundImage(null);
        }
        this.create();
    }

    public boolean forceFocus() {
        if (this.isDisposed()) {
            return false;
        }
        super.forceFocus();
        if (this.okButton.isDisposed()) {
            return false;
        }
        return this.okButton.forceFocus();
    }

    private void create() {
        int topMargin = Util.isLinux() ? 150 : 135;
        GridLayout layout = new GridLayout();
        layout.marginRight = 5;
        layout.marginLeft = 5;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 1;
        this.content = this;
        this.content.setLayout((Layout)layout);
        this.content.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.log.info("content style: {}, bgmode: {}", (Object)this.content.getStyle(), (Object)this.content.getBackgroundMode());
        if (this.getParent().getBackgroundImage() == null) {
            CLabel title = new CLabel(this.content, 0x1000000);
            title.setText("logFaces connection");
            FontData[] fd1 = title.getFont().getFontData();
            fd1[0].height += 10.0f;
            final Font font1 = new Font((Device)Display.getCurrent(), fd1[0]);
            title.setFont(font1);
            title.setForeground(EventStyles.FG_LFS);
            title.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    font1.dispose();
                }
            });
            GridData gd = new GridData(4, 4, true, true);
            gd.horizontalSpan = 1;
            gd.heightHint = topMargin;
            title.setLayoutData((Object)gd);
            layout = new GridLayout(1, false);
            layout.marginBottom = 5;
            layout.marginTop = 5;
            title.setLayout((Layout)layout);
            this.log.info("title style: {}, bgmode: {}", (Object)title.getStyle(), (Object)title.getBackgroundMode());
        } else {
            Composite spanner = new Composite(this.content, 0x40040000);
            GridData gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 1;
            gd.heightHint = topMargin;
            spanner.setLayoutData((Object)gd);
            this.log.info("spanner style: {}, bgmode: {}", (Object)spanner.getStyle(), (Object)spanner.getBackgroundMode());
        }
        Composite modeBar = new Composite(this.content, 0);
        modeBar.setLayoutData((Object)new GridData(4, 4, false, false));
        modeBar.setLayout((Layout)new GridLayout(3, false));
        this.modeComposite = new Composite(this.content, 0);
        this.modeComposite.setLayoutData((Object)new GridData(4, 1, false, false));
        this.modeComposite.setLayout((Layout)new GridLayout());
        this.serverMode = this.prefs.getBoolean("server_mode", false);
        final Button clientModeButton = new Button(modeBar, 16);
        clientModeButton.setSelection(!this.serverMode);
        clientModeButton.setText("Connect as client");
        clientModeButton.setToolTipText("Connect to logFaces server at specified end point");
        clientModeButton.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        clientModeButton.addKeyListener((KeyListener)this.keyListener);
        clientModeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionComposite2.this.serverMode = false;
                if (clientModeButton.getSelection() && ConnectionComposite2.this.serverPanel != null) {
                    ConnectionComposite2.this.buildMainComposite();
                    ConnectionComposite2.this.okButton.setText("Connect");
                }
            }
        });
        final Button serverModeButton = new Button(modeBar, 16);
        serverModeButton.setSelection(this.serverMode);
        serverModeButton.setText("Start as server");
        serverModeButton.setToolTipText("Receive log data directly at specified ports");
        serverModeButton.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        serverModeButton.addKeyListener((KeyListener)this.keyListener);
        serverModeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionComposite2.this.serverMode = true;
                if (serverModeButton.getSelection() && ConnectionComposite2.this.clientPanel != null) {
                    ConnectionComposite2.this.buildMainComposite();
                    ConnectionComposite2.this.okButton.setText("Start");
                }
            }
        });
        final Button autostart = new Button(modeBar, 32);
        autostart.setText("Auto-start");
        autostart.setToolTipText("When checked, the application will automatically\nstart with these settings next time");
        autostart.setLayoutData((Object)new GridData(3, 2, true, false));
        autostart.addKeyListener((KeyListener)this.keyListener);
        autostart.setSelection(this.prefs.getBoolean("lfs_auto_connect", false));
        autostart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionComposite2.this.connectionDetails.setAutoLogin(autostart.getSelection());
            }
        });
        this.buildMainComposite();
        layout = new GridLayout(4, false);
        layout.marginBottom = 8;
        Composite buttonBar = new Composite(this.content, 0);
        buttonBar.setLayout((Layout)layout);
        buttonBar.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(buttonBar, 0x1000040);
        label.setText(this.getSignatureText());
        label.setLayoutData((Object)new GridData(1, 3, false, true));
        FontData[] fd = label.getFont().getFontData();
        fd[0].height -= 3.0f;
        final Font font = new Font((Device)Display.getCurrent(), fd[0]);
        label.setFont(font);
        label.setForeground(EventStyles.FG_LFS);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
        Composite spanner2 = new Composite(buttonBar, 0);
        spanner2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.okButton = new Button(buttonBar, 8);
        if (this.serverMode) {
            this.okButton.setText("Start");
        } else {
            this.okButton.setText("Connect");
        }
        GridData gd = new GridData(3, 3, false, true);
        gd.widthHint = 100;
        this.okButton.setLayoutData((Object)gd);
        this.okButton.addKeyListener((KeyListener)this.keyListener);
        this.okButton.setFocus();
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionComposite2.this.handleOK();
            }
        });
        this.cancelButton = new Button(buttonBar, 8);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setLayoutData((Object)gd);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionComposite2.this.caller.cancel();
            }
        });
        this.okButton.forceFocus();
    }

    private void buildMainComposite() {
        if (this.clientPanel != null) {
            this.clientPanel.dispose();
            this.clientPanel = null;
        }
        if (this.serverPanel != null) {
            this.serverPanel.dispose();
            this.serverPanel = null;
        }
        if (this.serverMode) {
            this.createServerPanel();
        } else {
            this.createClientPanel();
        }
        this.modeComposite.layout(true);
        this.modeComposite.redraw();
    }

    private void createClientPanel() {
        GridLayout layout = new GridLayout(5, false);
        layout.verticalSpacing = 10;
        this.clientPanel = new Composite(this.modeComposite, 0);
        this.clientPanel.setLayout((Layout)layout);
        this.clientPanel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.workspaceLabel = new Label(this.clientPanel, 0);
        this.workspaceLabel.setText("&Use workspace :");
        this.workspaceLabel.setLayoutData((Object)new GridData(3, 2, false, false));
        this.workspace = new Combo(this.clientPanel, 8);
        this.workspace.select(0);
        this.workspace.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        this.workspace.addKeyListener((KeyListener)this.keyListener);
        this.workspace.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Workspace ws = ConnectionComposite2.this.workspaces.getWorkspace(ConnectionComposite2.this.workspace.getText());
                ConnectionComposite2.this.serverHost.setText(ws.getServerHost());
                ConnectionComposite2.this.serverPort.setText(Integer.toString(ws.getServerPort()));
                ConnectionComposite2.this.serverSsl.setSelection(ws.isSsl());
                ConnectionComposite2.this.caLink.setVisible(ws.isSsl());
            }
        });
        for (String name : this.workspaces.getNames()) {
            this.workspace.add(name);
        }
        this.workspace.setText(this.connectionDetails.getCurrentWorkspace());
        this.hostLabel = new Label(this.clientPanel, 0);
        this.hostLabel.setText("&Server :");
        this.hostLabel.setLayoutData((Object)new GridData(3, 2, false, false));
        GridData gd = new GridData(4, 4, false, false);
        gd.minimumWidth = 140;
        gd.widthHint = 140;
        this.serverHost = new Combo(this.clientPanel, 4);
        this.serverHost.setLayoutData((Object)gd);
        this.serverHost.addKeyListener((KeyListener)this.keyListener);
        this.serverPort = new Text(this.clientPanel, 2048);
        this.serverPort.setLayoutData((Object)new GridData(4, 4, true, false));
        this.serverPort.addKeyListener((KeyListener)this.keyListener);
        this.serverSsl = new Button(this.clientPanel, 32);
        this.serverSsl.setText("Secure");
        this.serverSsl.setToolTipText("If server is setup with SSL, this option must be checked.");
        this.serverSsl.setLayoutData((Object)new GridData(4, 4, true, false));
        this.serverSsl.addKeyListener((KeyListener)this.keyListener);
        this.serverSsl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionComposite2.this.connectionDetails.setSsl(ConnectionComposite2.this.serverSsl.getSelection());
                ConnectionComposite2.this.caLink.setVisible(ConnectionComposite2.this.serverSsl.getSelection());
            }
        });
        this.caLink = new Link(this.clientPanel, 0);
        this.caLink.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        this.caLink.setText("<a>CA cert</a>");
        this.caLink.setVisible(this.prefs.getBoolean("lfs_ssl", false));
        this.caLink.setToolTipText("If server is using CA not available on this computer,\nor server is using self signed certificates,\nimport them into local trust store directly from this server...");
        this.caLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                String host = ConnectionComposite2.this.serverHost.getText();
                int port = Integer.parseInt(ConnectionComposite2.this.serverPort.getText());
                CertificateInstallerJob job = new CertificateInstallerJob(ConnectionComposite2.this.parentShell, host, port);
                job.setUser(true);
                job.schedule();
            }
        });
        this.serverHost.setText(this.connectionDetails.getLfsHost());
        this.serverHost.setToolTipText("Host name or IP address of\nlogFaces server to connect to");
        for (String host : this.connectionDetails.getHostNames()) {
            this.serverHost.add(host);
        }
        this.serverPort.setText(Integer.toString(this.connectionDetails.getLfsPort()));
        this.serverPort.setToolTipText("Port where server expects client connections.\nDefault is 8050");
        this.serverSsl.setSelection(this.prefs.getBoolean("lfs_ssl", false));
        this.connectionDetails.setServerMode(false);
        this.updateOkButton();
    }

    private void createServerPanel() {
        GridLayout layout = new GridLayout(4, false);
        layout.verticalSpacing = 10;
        this.serverPanel = new Composite(this.modeComposite, 0);
        this.serverPanel.setLayout((Layout)layout);
        this.serverPanel.setLayoutData((Object)new GridData(4, 1, true, false, 4, 1));
        GridData pgd = new GridData(4, 4, false, false);
        pgd.widthHint = 50;
        GridData typegd = new GridData(4, 4, false, false);
        this.tcpEnabled = new Button(this.serverPanel, 32);
        this.tcpEnabled.setText("Log4x TCP port:");
        this.tcpEnabled.setToolTipText("Use TCP socket receiver for log4j like log sources");
        this.tcpEnabled.setLayoutData((Object)typegd);
        this.tcpEnabled.addKeyListener((KeyListener)this.keyListener);
        this.tcpEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ConnectionComposite2.this.tcpEnabled.getSelection();
                ConnectionComposite2.this.connectionDetails.setTcpEnabled(enabled);
                ConnectionComposite2.this.tcpPort.setEnabled(enabled);
                if (enabled) {
                    ConnectionComposite2.this.tcpPort.setFocus();
                }
                ConnectionComposite2.this.updateOkButton();
            }
        });
        this.tcpPort = new Text(this.serverPanel, 2048);
        this.tcpPort.setLayoutData((Object)pgd);
        this.tcpPort.addKeyListener((KeyListener)this.keyListener);
        this.tcpSysEnabled = new Button(this.serverPanel, 32);
        this.tcpSysEnabled.setText("Syslog TCP port:");
        this.tcpSysEnabled.setToolTipText("Use TCP socket receiver for syslog sources");
        this.tcpSysEnabled.setLayoutData((Object)typegd);
        this.tcpSysEnabled.addKeyListener((KeyListener)this.keyListener);
        this.tcpSysEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ConnectionComposite2.this.tcpSysEnabled.getSelection();
                ConnectionComposite2.this.connectionDetails.setTcpSysEnabled(enabled);
                ConnectionComposite2.this.tcpSysPort.setEnabled(enabled);
                if (enabled) {
                    ConnectionComposite2.this.tcpSysPort.setFocus();
                }
                ConnectionComposite2.this.updateOkButton();
            }
        });
        this.tcpSysPort = new Text(this.serverPanel, 2048);
        this.tcpSysPort.setLayoutData((Object)pgd);
        this.tcpSysPort.addKeyListener((KeyListener)this.keyListener);
        this.udpEnabled = new Button(this.serverPanel, 32);
        this.udpEnabled.setText("Log4x UDP port:");
        this.udpEnabled.setToolTipText("Use UDP socket receiver for log4j like log sources");
        this.udpEnabled.setLayoutData((Object)typegd);
        this.udpEnabled.addKeyListener((KeyListener)this.keyListener);
        this.udpEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ConnectionComposite2.this.udpEnabled.getSelection();
                ConnectionComposite2.this.connectionDetails.setUdpEnabled(enabled);
                ConnectionComposite2.this.udpPort.setEnabled(enabled);
                if (enabled) {
                    ConnectionComposite2.this.udpPort.setFocus();
                }
                ConnectionComposite2.this.updateOkButton();
            }
        });
        this.udpPort = new Text(this.serverPanel, 2048);
        this.udpPort.addKeyListener((KeyListener)this.keyListener);
        this.udpPort.setLayoutData((Object)pgd);
        this.udpSysEnabled = new Button(this.serverPanel, 32);
        this.udpSysEnabled.setText("Syslog UDP port:");
        this.udpSysEnabled.setToolTipText("Use TCP socket receiver for syslog sources");
        this.udpSysEnabled.setLayoutData((Object)typegd);
        this.udpSysEnabled.addKeyListener((KeyListener)this.keyListener);
        this.udpSysEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ConnectionComposite2.this.udpSysEnabled.getSelection();
                ConnectionComposite2.this.connectionDetails.setUdpSysEnabled(enabled);
                ConnectionComposite2.this.udpSysPort.setEnabled(enabled);
                if (enabled) {
                    ConnectionComposite2.this.udpSysPort.setFocus();
                }
                ConnectionComposite2.this.updateOkButton();
            }
        });
        this.udpSysPort = new Text(this.serverPanel, 2048);
        this.udpSysPort.addKeyListener((KeyListener)this.keyListener);
        this.udpSysPort.setLayoutData((Object)pgd);
        this.tcpEnabled.setSelection(this.prefs.getBoolean("tcp_enabled", false));
        this.udpEnabled.setSelection(this.prefs.getBoolean("udp_enabled", false));
        this.tcpSysEnabled.setSelection(this.prefs.getBoolean("tcp_sys_enabled", false));
        this.udpSysEnabled.setSelection(this.prefs.getBoolean("udp_sys_enabled", false));
        this.tcpPort.setText(Integer.toString(this.connectionDetails.getTcpPort()));
        this.tcpPort.setEnabled(this.tcpEnabled.getSelection());
        this.tcpSysPort.setText(Integer.toString(this.connectionDetails.getTcpSysPort()));
        this.tcpSysPort.setEnabled(this.tcpSysEnabled.getSelection());
        this.udpPort.setText(Integer.toString(this.connectionDetails.getUdpPort()));
        this.udpPort.setEnabled(this.udpEnabled.getSelection());
        this.udpSysPort.setText(Integer.toString(this.connectionDetails.getUdpSysPort()));
        this.udpSysPort.setEnabled(this.udpSysEnabled.getSelection());
        this.connectionDetails.setServerMode(true);
    }

    protected void handleOK() {
        if (!this.serverMode) {
            if (this.serverHost.getText().length() == 0) {
                MessageDialog.openError((Shell)this.parentShell, (String)"Invalid host name", (String)"Host name field must not be blank.");
                return;
            }
            if (!this.validatePortNumber(this.serverPort.getText())) {
                MessageDialog.openError((Shell)this.parentShell, (String)"Invalid port number", (String)"Port number field must be positive numeric value in range of 1-65000");
                return;
            }
            this.connectionDetails.setCurrentWorkspace(this.workspace.getText());
            this.connectionDetails.setLfsHost(this.serverHost.getText());
            this.connectionDetails.setLfsPort(Integer.parseInt(this.serverPort.getText()));
            this.connectionDetails.setSsl(this.serverSsl.getSelection());
        } else {
            if (!(this.tcpEnabled.getSelection() || this.udpEnabled.getSelection() || this.tcpSysEnabled.getSelection() || this.udpSysEnabled.getSelection())) {
                MessageDialog.openError((Shell)this.parentShell, (String)"Missing input", (String)"Please specify at least one listening port.");
                return;
            }
            if (this.tcpEnabled.getSelection() && !this.validatePortNumber(this.tcpPort.getText()) || this.tcpSysEnabled.getSelection() && !this.validatePortNumber(this.tcpSysPort.getText())) {
                MessageDialog.openError((Shell)this.parentShell, (String)"Invalid TCP port number", (String)"Port number field must be positive numeric value in range of 1-65535");
                return;
            }
            if (this.udpEnabled.getSelection() && !this.validatePortNumber(this.udpPort.getText()) || this.udpSysEnabled.getSelection() && !this.validatePortNumber(this.udpSysPort.getText())) {
                MessageDialog.openError((Shell)this.parentShell, (String)"Invalid UDP port number", (String)"Port number field must be positive numeric value in range of 1-65535");
                return;
            }
            this.connectionDetails.setTcpEnabled(this.tcpEnabled.getSelection());
            this.connectionDetails.setTcpSysEnabled(this.tcpSysEnabled.getSelection());
            this.connectionDetails.setTcpPort(Integer.parseInt(this.tcpPort.getText()));
            this.connectionDetails.setTcpSysPort(Integer.parseInt(this.tcpSysPort.getText()));
            this.connectionDetails.setUdpEnabled(this.udpEnabled.getSelection());
            this.connectionDetails.setUdpSysEnabled(this.udpSysEnabled.getSelection());
            this.connectionDetails.setUdpPort(Integer.parseInt(this.udpPort.getText()));
            this.connectionDetails.setUdpSysPort(Integer.parseInt(this.udpSysPort.getText()));
        }
        this.connectionDetails.save();
        this.caller.activate();
    }

    private void updateOkButton() {
        if (this.okButton == null || this.okButton.isDisposed()) {
            return;
        }
        if (this.serverMode) {
            this.okButton.setEnabled(this.udpEnabled.getSelection() || this.tcpEnabled.getSelection() || this.udpSysEnabled.getSelection() || this.tcpSysEnabled.getSelection());
        } else {
            this.okButton.setEnabled(!this.serverHost.getText().isEmpty() && !this.serverPort.getText().isEmpty());
        }
    }

    private boolean validatePortNumber(String text) {
        try {
            int num = Integer.parseInt(text);
            if (num > 0 && num < 65535) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private String getSignatureText() {
        String signature = "\u00a9 2025 Moonlit Software Ltd\nAll rights reserved";
        if (this.getParent().getBackgroundImage() == null) {
            return String.format("%s, v%s", signature, Utils.getProductVersion());
        }
        return signature;
    }

    class ThisKeyListener
    implements KeyListener {
        ThisKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                ConnectionComposite2.this.handleOK();
            } else if (e.keyCode == 27) {
                System.exit(0);
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

