/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ComboInputDialog
extends Dialog {
    private IDialogSettings settings;
    private String title;
    private String message;
    private String value = "";
    private IInputValidator validator;
    private Button okButton;
    private String[] choices;
    private Combo combo;
    private Text errorMessageText;
    private String errorMessage;
    private boolean readOnly;

    public ComboInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, Collection<String> choices, String initialValue, IInputValidator validator) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.choices = choices.toArray(new String[choices.size()]);
        this.value = initialValue == null ? "" : initialValue;
        this.validator = validator;
    }

    public ComboInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, IDialogSettings ds) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.validator = null;
        this.settings = ds;
        if (this.settings != null) {
            String[] strings = this.settings.getArray("choices");
            this.choices = strings != null ? strings : new String[]{};
            this.value = this.settings.get("lastUsed");
            if (this.value == null) {
                this.value = "";
            }
        } else {
            this.choices = new String[0];
            this.value = "";
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.value = this.combo.getText();
            if (this.settings != null && this.value != null & !this.value.isEmpty()) {
                TreeSet set = Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])this.choices));
                set.add(this.value);
                this.settings.put("lastUsed", this.value);
                this.settings.put("choices", set.toArray(new String[set.size()]));
            }
        } else {
            this.value = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.combo.setFocus();
        if (this.value != null) {
            this.combo.setText(this.value);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.combo = new Combo(composite, this.readOnly ? 8 : 4);
        if (this.choices != null) {
            String[] stringArray = this.choices;
            int n = this.choices.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item != null) {
                    this.combo.add(item);
                }
                ++n2;
            }
        }
        this.combo.setLayoutData((Object)new GridData(768));
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ComboInputDialog.this.validateInput();
            }
        });
        this.errorMessageText = new Text(composite, 72);
        this.errorMessageText.setLayoutData((Object)new GridData(768));
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.errorMessage);
        ComboInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Combo getCombo() {
        return this.combo;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    protected void validateInput() {
        String errorMsg = null;
        if (this.validator != null) {
            errorMsg = this.validator.isValid(this.combo.getText());
        }
        this.setErrorMessage(errorMsg);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

