/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.Columns;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.model.ColumnSetModel;
import com.moonlit.logfaces.client.model.ColumnSetVO;
import com.moonlit.logfaces.client.model.LogHeaderInfoVO;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.client.utils.Utils;
import java.util.BitSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ColumnsDlg
extends Dialog {
    private ColumnSetVO cset = null;
    private ColumnSetModel defaults = ColumnSetModel.getInstance();
    private LogHeaderInfoVO[] headers;
    private int nofColumns = Columns.getNofColumns();
    private Button[] check = new Button[this.nofColumns];
    private Button[] custom = new Button[4];
    private Button okButton;
    private Button cancelButton;
    private Label label;
    private static final Logger log = LogManager.getLogger(ColumnsDlg.class);

    public ColumnsDlg(Shell parentShell, LogHeaderInfoVO[] headers) {
        super(parentShell);
        this.setShellStyle(2160);
        this.headers = headers;
        if (this.nofColumns > headers.length) {
            this.nofColumns = headers.length;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 10;
        gridLayout.marginLeft = 10;
        gridLayout.marginRight = 10;
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        Composite topComposite = new Composite(container, 0);
        topComposite.setLayout((Layout)new GridLayout(4, true));
        topComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite leftComposite = new Composite(container, 2);
        leftComposite.setLayout((Layout)new GridLayout(1, true));
        leftComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Group leftGroup = new Group(leftComposite, 0);
        leftGroup.setLayout((Layout)new GridLayout(1, true));
        leftGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        leftGroup.setText("Event attributes");
        Composite rightComposite = new Composite(container, 0);
        rightComposite.setLayout((Layout)new GridLayout(1, true));
        rightComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Group rightGroup = new Group(rightComposite, 0);
        rightGroup.setLayout((Layout)new GridLayout(1, true));
        rightGroup.setLayoutData((Object)new GridData(4, 1, true, true, 1, 1));
        rightGroup.setText("Diagnostic context");
        GridData gd1 = new GridData(4, 4, true, true, 1, 4);
        gd1.widthHint = 100;
        GridData gd2 = new GridData(4, 2, true, true, 4, 1);
        this.label = new Label(topComposite, 0);
        this.label.setText("Quick column selectors (right click to customize):");
        this.label.setLayoutData((Object)gd2);
        SetupMouseAdapter adapter = new SetupMouseAdapter();
        int i = 0;
        while (i < 4) {
            this.custom[i] = new Button(topComposite, 0);
            this.custom[i].setText(this.defaults.getColumnSet(i).getName());
            this.custom[i].setData("index", (Object)i);
            this.custom[i].setData("setup", (Object)false);
            this.custom[i].setLayoutData((Object)gd1);
            this.custom[i].addMouseListener((MouseListener)adapter);
            ++i;
        }
        i = 0;
        while (i < this.nofColumns) {
            String columnName;
            if (!Columns.isMdcColumn(i) || StringUtils.hasText(columnName = Columns.column2mdc(i))) {
                Group group = i == 11 || Columns.isMdcColumn(i) ? rightGroup : leftGroup;
                this.check[i] = new Button((Composite)group, 32);
                this.check[i].setData((Object)i);
                this.check[i].setLayoutData((Object)gd2);
                if (Columns.isMdcColumn(i)) {
                    String columnName2 = Columns.column2mdc(i);
                    this.check[i].setText(columnName2);
                    this.check[i].setEnabled(StringUtils.hasText(columnName2));
                } else if (i == 10) {
                    this.check[i].setText("Thrown");
                } else if (i == 0) {
                    this.check[i].setText("Severity");
                } else {
                    this.check[i].setText(this.headers[i].getName());
                }
                this.check[i].setSelection(this.headers[i].isVisible() && StringUtils.hasText(this.check[i].getText()));
                this.check[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int i = (Integer)e.widget.getData();
                        ColumnsDlg.this.set(i, ((Button)e.widget).getSelection());
                    }
                });
            }
            ++i;
        }
        container.pack();
        return container;
    }

    private void applySet(ColumnSetVO cset) {
        BitSet bits = cset.getMask();
        int i = 0;
        while (i < this.nofColumns) {
            if (this.check[i] != null) {
                this.check[i].setSelection(bits.get(i));
            }
            ++i;
        }
    }

    private void set(int col, boolean set) {
        if (this.check[col] != null) {
            this.check[col].setSelection(set);
        }
    }

    private void saveSet() {
        if (this.cset != null) {
            BitSet mask = Utils.mask(0L);
            int i = 0;
            while (i < this.nofColumns) {
                mask.set(i, this.check[i].getSelection());
                ++i;
            }
            this.cset.setMask(mask);
            InputDialog dialog = new InputDialog(this.getShell(), "Rename", "Give a custom name to this set of columns", this.cset.getName(), null);
            if (dialog.open() == 0) {
                this.cset.setName(dialog.getValue());
            }
            try {
                WorkspaceHolder.getInstance().save();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void setupMode(int index) {
        this.saveSet();
        this.cset = index >= 0 ? this.defaults.getColumnSet(index) : null;
        int i = 0;
        while (i < 4) {
            this.custom[i].setText(this.defaults.getColumnSet(i).getName());
            this.custom[i].setData("setup", (Object)(index == i ? 1 : 0));
            FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)this.custom[i].getFont()).setStyle(index == i ? 1 : 0);
            Font font = boldDescriptor.createFont((Device)this.custom[i].getDisplay());
            this.custom[i].setFont(font);
            this.custom[i].setEnabled(index == i || index == -1);
            this.custom[i].redraw();
            ++i;
        }
        this.okButton.setEnabled(this.cset == null);
        this.cancelButton.setEnabled(this.cset == null);
        this.label.setText(this.cset == null ? "Quick column selectors (right click to customize):" : "Select needed columns and click on this button again to save:");
        if (this.cset != null) {
            this.applySet(this.cset);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 256, "Use this set as default", false);
        GridData gd = new GridData(1, 2, true, false);
        button.setLayoutData((Object)gd);
        button.setToolTipText("Use this set of columns as default for\nwhenever new data tables are created");
        button.setImage(ImageHolder.getInstance().getButtonImage("icons/prop_ps.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogHeaderInfoVO[] clone = Columns.makeDefaultHeaders();
                int i = 0;
                while (i < ColumnsDlg.this.nofColumns) {
                    clone[i].setVisible(false);
                    if (ColumnsDlg.this.check[i] != null) {
                        clone[i].setVisible(ColumnsDlg.this.check[i].getSelection());
                    }
                    ++i;
                }
                Columns.updateDefaultHeaders(clone);
                MessageDialog.openInformation((Shell)ColumnsDlg.this.getShell(), (String)"Done", (String)"This set of columns will be used as default");
            }
        });
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialLocation(Point initialSize) {
        return Display.getCurrent().getCursorLocation();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Columns");
        newShell.setImage(ImageHolder.getInstance().getImage("icons/columns.gif"));
    }

    protected void okPressed() {
        int i = 0;
        while (i < this.nofColumns) {
            this.headers[i].setVisible(false);
            if (this.check[i] != null) {
                this.headers[i].setVisible(this.check[i].getSelection());
            }
            ++i;
        }
        super.okPressed();
    }

    class SetupMouseAdapter
    extends MouseAdapter {
        SetupMouseAdapter() {
        }

        public void mouseDown(MouseEvent e) {
            Button button = (Button)e.getSource();
            button.forceFocus();
            int index = (Integer)button.getData("index");
            if (e.button > 1) {
                if (((Boolean)button.getData("setup")).booleanValue()) {
                    index = -1;
                }
                ColumnsDlg.this.setupMode(index);
                return;
            }
            if (ColumnsDlg.this.cset != null) {
                ColumnsDlg.this.setupMode(-1);
                return;
            }
            ColumnsDlg.this.applySet(ColumnsDlg.this.defaults.getColumnSet(index));
        }
    }
}

