/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import java.util.Collection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;

public class ColumnFilterDlg
extends Dialog {
    private Combo combo;
    private Collection<String> options;
    private boolean editable;
    private String option;

    public ColumnFilterDlg(IWorkbenchPartSite site, Collection<String> options, boolean editable) {
        super(site.getShell());
        this.options = options;
        this.editable = editable;
        this.setShellStyle(65552);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        if (!this.editable) {
            label.setText("Set view filter :");
        } else {
            label.setText("Set view filter (use * as wildcard) :");
        }
        GridData gd = new GridData(4, 2, true, false, 3, 1);
        gd.widthHint = 250;
        this.combo = new Combo(container, this.editable ? 4 : 8);
        this.combo.setVisibleItemCount(20);
        this.combo.setLayoutData((Object)gd);
        for (String option : this.options) {
            this.combo.add(option);
        }
        this.combo.select(0);
        this.combo.setFocus();
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ColumnFilterDlg.this.option = ColumnFilterDlg.this.combo.getText();
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnFilterDlg.this.option = ColumnFilterDlg.this.combo.getText();
            }
        });
        this.combo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ColumnFilterDlg.this.buttonPressed(0);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 9, "Reset", false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialLocation(Point initialSize) {
        return Display.getCurrent().getCursorLocation();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.option = this.combo.getText();
                super.okPressed();
                break;
            }
            case 9: {
                this.option = null;
                super.okPressed();
                break;
            }
            case 1: {
                super.cancelPressed();
            }
        }
    }

    public String getOption() {
        return this.option;
    }
}

