/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.Workspace;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.server.util.Password;
import java.net.PasswordAuthentication;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AuthDialog
extends Dialog {
    private Text userNameText;
    private Text passwordText;
    private CLabel note;
    private String userName;
    private String password;
    private boolean autologin;
    private Button remember;
    private Workspace workspace;
    private IDialogSettings settings;

    public AuthDialog(Workspace ws) {
        super(Application.getShell());
        this.setShellStyle(67680);
        this.settings = Application.getDialogSettings();
        this.workspace = ws;
        this.userName = this.workspace.getUserName();
        this.password = this.workspace.getPassword();
        if (Password.isObfuscated((String)this.password)) {
            this.password = Password.deobfuscate((String)this.password);
        }
    }

    public AuthDialog(PasswordAuthentication pa) {
        super(Application.getShell());
        this.setShellStyle(67680);
        this.settings = Application.getDialogSettings();
        if (pa != null) {
            this.userName = pa.getUserName();
            this.password = new String(pa.getPassword());
        }
    }

    public AuthDialog() {
        super(Application.getShell());
        this.setShellStyle(67680);
        this.settings = Application.getDialogSettings();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        this.note = new CLabel(container, 0);
        this.note.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        this.note.setImage(ImageHolder.getInstance().getImage("/icons/key.gif"));
        this.note.setText("This logFaces server requires user authentication.\nPlease provide your credentials below.");
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData());
        label.setText("User name:");
        this.userNameText = new Text(container, 2048);
        this.userNameText.setText(this.getPromptUserName());
        this.userNameText.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        this.userNameText.setFocus();
        label = new Label(container, 0);
        label.setLayoutData((Object)new GridData());
        label.setText("Password:");
        this.passwordText = new Text(container, 0x400800);
        this.passwordText.setText(this.getPromptPassword());
        this.passwordText.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        label = new Label(container, 258);
        label.setLayoutData((Object)new GridData(4, 2, true, true, 2, 2));
        if (this.workspace != null) {
            this.remember = new Button(container, 32);
            this.remember.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
            this.remember.setText("next time use those cridentials automatically");
            this.remember.setSelection(this.workspace.isAutoLogin());
        }
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Login is required");
        newShell.setImage(ImageHolder.getInstance().getImage("icons/lf16.png"));
    }

    protected void okPressed() {
        this.userName = this.userNameText.getText();
        this.password = this.passwordText.getText();
        boolean bl = this.autologin = this.workspace != null ? this.remember.getSelection() : false;
        if (this.userName.length() == 0 || this.password.length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Invalid input", (String)"Credentials shouldn't be empty");
            return;
        }
        if (this.workspace != null) {
            Application.getPrefs().putBoolean("lfs_auto_login", this.remember.getSelection());
        }
        this.settings.put("AuthDialog.userName", this.userName);
        this.settings.put("AuthDialog.password", this.getPassword());
        this.settings.put("AuthDialog.autologin", this.autologin);
        Application.saveDialogSettings();
        super.okPressed();
    }

    protected String getPromptUserName() {
        if (StringUtils.hasText(this.userName)) {
            return this.userName;
        }
        String string = this.settings.get("AuthDialog.userName");
        return StringUtils.hasText(string) ? string : "";
    }

    protected String getPromptPassword() {
        if (StringUtils.hasText(this.password)) {
            return this.password;
        }
        String string = this.settings.get("AuthDialog.password");
        if (Password.isObfuscated((String)string)) {
            string = Password.deobfuscate((String)string);
        }
        return StringUtils.hasText(string) ? string : "";
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return Password.obfuscate((String)this.password);
    }

    public String getClearPassword() {
        return this.password;
    }

    public boolean getAutologin() {
        return this.autologin;
    }

    public void setNote(String title) {
        this.note.setText(title != null ? title : "");
    }
}

