/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dashboard;

import com.moonlit.logfaces.client.dashboard.Widget;
import com.moonlit.logfaces.client.dashboard.WidgetShell;
import com.moonlit.logfaces.client.utils.ColorPicker;
import com.moonlit.logfaces.server.stats.StatCategory;
import java.awt.Color;
import java.awt.Paint;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CustomXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.RangeType;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class WidgetViewTimeline
extends WidgetShell {
    private ColorPicker colorPicker = ColorPicker.getInstance();
    private TimeTableXYDataset dataset;
    private LevelRenderer renderer;
    private SimpleDateFormat tipdf = new SimpleDateFormat("HH:mm");
    private SimpleDateFormat daydf = new SimpleDateFormat("dd MMMM");

    public WidgetViewTimeline(Widget widget) {
        super(widget, widget.getDashboard().getDesktop());
    }

    @Override
    protected void createWidgetView() {
        DateAxis dateaxis = new DateAxis();
        dateaxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        NumberAxis numberaxis = new NumberAxis(this.widget.getSliceInfo().getType() == StatCategory.integral ? "" : "Number of events");
        numberaxis.setRangeType(RangeType.POSITIVE);
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.dataset = (TimeTableXYDataset)this.widget.getModel().makeTimeDataset();
        this.renderer = new LevelRenderer();
        XYPlot plot = new XYPlot((XYDataset)this.dataset, (ValueAxis)dateaxis, (ValueAxis)numberaxis, (XYItemRenderer)this.renderer);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderVisible(false);
        chart.setBorderPaint(null);
        ChartComposite chartComposite = new ChartComposite(this.getContentPane(), 0, chart, 680, 420, 300, 200, 2600, 2600, true, false, false, false, false, true);
        chartComposite.setRangeZoomable(false);
        chartComposite.setDomainZoomable(false);
        chartComposite.setMenu(null);
        chartComposite.addChartMouseListener((ChartMouseListener)new ThisMouseListener());
        this.widgetView = chartComposite;
    }

    class LevelRenderer
    extends StackedXYBarRenderer {
        int selectedRow = -1;
        int selectedCol = -1;

        public LevelRenderer() {
            this.setBaseToolTipGenerator((XYToolTipGenerator)new ThisTooltipsGenerator());
            this.setBaseSeriesVisibleInLegend(false);
            this.setDrawBarOutline(true);
            StandardXYBarPainter painter = new StandardXYBarPainter();
            this.setBarPainter((XYBarPainter)painter);
            this.setShadowVisible(false);
            this.setMargin(0.0);
        }

        public void select(int row, int col) {
            this.selectedRow = row;
            this.selectedCol = col;
            this.notifyListeners(new RendererChangeEvent((Object)this));
        }

        public Paint getItemPaint(int row, int col) {
            String series = WidgetViewTimeline.this.dataset.getSeriesKey(row).toString();
            Color color = WidgetViewTimeline.this.colorPicker.pickAwt(series);
            if (row == this.selectedRow && col == this.selectedCol) {
                return color.darker();
            }
            return color;
        }

        public Paint getItemOutlinePaint(int row, int col) {
            if (row == this.selectedRow && col == this.selectedCol) {
                return Color.gray;
            }
            return Color.darkGray;
        }

        public Paint getSeriesOutlinePaint(int row) {
            if (row == this.selectedRow) {
                return Color.gray;
            }
            return Color.gray;
        }
    }

    class ThisMouseListener
    implements ChartMouseListener {
        ThisMouseListener() {
        }

        private XYItemEntity trackSelection(ChartMouseEvent event) {
            ChartEntity entity = event.getEntity();
            if (entity != null && entity instanceof XYItemEntity) {
                XYItemEntity item = (XYItemEntity)entity;
                WidgetViewTimeline.this.renderer.select(item.getSeriesIndex(), item.getItem());
                return item;
            }
            WidgetViewTimeline.this.renderer.select(-1, -1);
            return null;
        }

        public void chartMouseMoved(ChartMouseEvent event) {
            this.trackSelection(event);
        }

        public void chartMouseClicked(ChartMouseEvent event) {
            XYItemEntity item = this.trackSelection(event);
            if (item != null) {
                boolean fullRange = 1 != event.getTrigger().getButton();
                TimeTableXYDataset ds = (TimeTableXYDataset)item.getDataset();
                TimePeriod period = ds.getTimePeriod(item.getItem());
                if (fullRange) {
                    int nofItems = WidgetViewTimeline.this.dataset.getItemCount();
                    period = new SimpleTimePeriod(WidgetViewTimeline.this.dataset.getTimePeriod(0).getStart(), WidgetViewTimeline.this.dataset.getTimePeriod(nofItems - 1).getEnd());
                }
                String series = ds.getSeriesKey(item.getSeriesIndex()).toString();
                WidgetViewTimeline.this.widget.drill(period, series);
            }
        }
    }

    class ThisTooltipsGenerator
    extends CustomXYToolTipGenerator {
        ThisTooltipsGenerator() {
        }

        public String getToolTipText(int series, int item) {
            try {
                TimePeriod period = WidgetViewTimeline.this.dataset.getTimePeriod(item);
                return String.format("%s %s - %s%n%s (%d)", WidgetViewTimeline.this.daydf.format(period.getStart()), WidgetViewTimeline.this.tipdf.format(period.getStart()), WidgetViewTimeline.this.tipdf.format(period.getEnd()), WidgetViewTimeline.this.dataset.getSeriesKey(series), WidgetViewTimeline.this.dataset.getY(series, item).longValue());
            }
            catch (Exception e) {
                return "";
            }
        }
    }
}

