/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dashboard;

import com.google.common.collect.Maps;
import com.moonlit.logfaces.client.dashboard.SliceInfo;
import com.moonlit.logfaces.client.dashboard.Widget;
import com.moonlit.logfaces.client.dashboard.WidgetShell;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.utils.ColorPicker;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.stats.StatCategory;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.JFreeChartEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.AbstractPieLabelDistributor;
import org.jfree.chart.plot.PieLabelDistributor;
import org.jfree.chart.plot.PieLabelRecord;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.PieDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class WidgetViewPie
extends WidgetShell {
    public WidgetViewPie(Widget widget) {
        super(widget, widget.getDashboard().getDesktop());
    }

    @Override
    protected void createWidgetView() {
        JFreeChart chart = ChartFactory.createPieChart(null, (PieDataset)this.widget.getModel().makePieDataset(), (boolean)false, (boolean)true, (boolean)true);
        chart.setBorderVisible(false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setNoDataMessage(String.format("No data for '%s' category", this.widget.getSliceInfo().getName()));
        plot.setIgnoreZeroValues(true);
        plot.setShadowPaint(null);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlineStroke(null);
        plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator("{0} = {1} ({2})"));
        plot.setLabelLinksVisible(true);
        plot.setLabelBackgroundPaint((Paint)Utils.swt2awtColor(EventStyles.BG_LFS));
        plot.setLabelDistributor((AbstractPieLabelDistributor)new ThisPieLabelDistributor());
        this.applyRenderer(plot);
        ChartComposite chartComposite = new ChartComposite(this.getContentPane(), 2048, chart, 680, 420, 300, 200, 2600, 2600, true, false, false, false, false, true);
        chartComposite.setBackground(EventStyles.BG_LFS);
        chartComposite.setRangeZoomable(false);
        chartComposite.setDomainZoomable(false);
        chartComposite.setMenu(null);
        chartComposite.addChartMouseListener((ChartMouseListener)new ThisMouseListener());
        this.widgetView = chartComposite;
    }

    private void applyRenderer(PiePlot plot) {
        ColorPicker picker = ColorPicker.getInstance();
        SliceInfo info = this.widget.getSliceInfo();
        if (info.getType() == StatCategory.attributes && info.getAttribute() == EventAttribute.loggerLevel) {
            for (LfsLevel level : LfsLevel.toList()) {
                Color color = Utils.swt2awtColor(EventStyles.getInstance().getDarkerBackground(level.intLevel()));
                plot.setSectionPaint((Comparable)((Object)level.toString()), (Paint)color);
            }
            return;
        }
        if (info.getType() == StatCategory.tags) {
            for (TagVO tag : TagsModel.getInstance().getTags()) {
                Color color = Utils.swt2awtColor(tag.getColor());
                plot.setSectionPaint((Comparable)((Object)tag.getName()), (Paint)color);
            }
            return;
        }
        for (Object key : plot.getDataset().getKeys()) {
            plot.setSectionPaint((Comparable)((Object)key.toString()), (Paint)picker.pickAwt(key.toString()));
        }
    }

    class ThisMouseListener
    implements ChartMouseListener {
        ThisMouseListener() {
        }

        public void chartMouseMoved(ChartMouseEvent event) {
        }

        public void chartMouseClicked(ChartMouseEvent event) {
            ChartEntity entity = event.getEntity();
            if (entity instanceof PieSectionEntity) {
                PieSectionEntity section = (PieSectionEntity)entity;
                WidgetViewPie.this.widget.drill(null, section.getSectionKey().toString());
                return;
            }
            if (entity instanceof JFreeChartEntity) {
                Point point = event.getTrigger().getPoint();
                JFreeChartEntity chartEntity = (JFreeChartEntity)entity;
                PiePlot plot = (PiePlot)chartEntity.getChart().getPlot();
                ThisPieLabelDistributor distributor = (ThisPieLabelDistributor)plot.getLabelDistributor();
                distributor.drill(point);
            }
        }
    }

    class ThisPieLabelDistributor
    extends PieLabelDistributor {
        Map<String, PieLabelRecord> sticky;

        public ThisPieLabelDistributor() {
            super(0);
            this.sticky = Maps.newHashMap();
        }

        public void distributeLabels(double minY, double height) {
            super.distributeLabels(minY, height);
            int i = 0;
            while (i < this.getItemCount()) {
                PieLabelRecord record = this.getPieLabelRecord(i);
                this.sticky.put(record.getKey().toString(), record);
                ++i;
            }
        }

        public void drill(Point point) {
            for (String key : this.sticky.keySet()) {
                PieLabelRecord record = this.sticky.get(key);
                if (!((double)point.y >= record.getLowerY()) || !((double)point.y <= record.getUpperY())) continue;
                WidgetViewPie.this.widget.drill(null, key);
            }
        }
    }
}

