/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dashboard;

import com.google.common.eventbus.Subscribe;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.dashboard.Widget;
import com.moonlit.logfaces.client.dashboard.WidgetShell;
import com.moonlit.logfaces.client.gis.GIS;
import com.moonlit.logfaces.client.gis.GisLocation;
import com.moonlit.logfaces.client.options.Option;
import com.moonlit.logfaces.client.options.ScalarOption;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.client.widgets.GisComposite;
import com.moonlit.logfaces.server.util.LfsEventBus;
import java.util.Map;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.jxmapviewer.viewer.GeoPosition;

public class WidgetViewGis
extends WidgetShell {
    private GisComposite gisComposite;

    public WidgetViewGis(Widget widget) {
        super(widget, widget.getDashboard().getDesktop());
    }

    @Override
    protected void createWidgetView() {
        this.widgetView = new Composite(this.getContentPane(), 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.widgetView.setLayout((Layout)layout);
        this.widgetView.setLayoutData((Object)new GridData(1808));
        if (Util.isWindows()) {
            this.gisComposite = new GisComposite(this.widgetView);
            this.loadState();
        } else {
            Display.getDefault().asyncExec(() -> this.note("Currently not supported on this OS", false, true));
        }
        LfsEventBus.getInstance().register((Object)this);
        this.setImage(ImageHolder.getInstance().getImage("icons/map.gif"));
    }

    private void saveState() {
        if (this.gisComposite != null && !this.gisComposite.isDisposed()) {
            GeoPosition center = this.gisComposite.getCenter();
            Map<String, Option> options = this.widget.getOptions();
            options.put("zoom", new ScalarOption("zoom", this.gisComposite.getZoom()));
            options.put("lat", new ScalarOption("lat", center.getLatitude()));
            options.put("lon", new ScalarOption("lon", center.getLongitude()));
        }
    }

    private void loadState() {
        int zoom = GIS.getInstance().getLastZoom();
        double lat = GIS.getInstance().getLastLat();
        double lon = GIS.getInstance().getLastLon();
        ScalarOption option = this.widget.getOption("zoom", ScalarOption.class);
        if (option != null) {
            zoom = option.getInt(zoom);
        }
        if ((option = this.widget.getOption("lat", ScalarOption.class)) != null) {
            lat = option.getDouble(lat);
        }
        if ((option = this.widget.getOption("lon", ScalarOption.class)) != null) {
            lon = option.getDouble(lon);
        }
        this.gisComposite.display(this.widget.getModel().makeLocations(), false);
        this.gisComposite.setPosition(zoom, lat, lon);
    }

    @Override
    public void close(boolean remove) {
        this.saveState();
        LfsEventBus.getInstance().unregister((Object)this);
        super.close(remove);
    }

    @Subscribe
    public void handleLfcEvent(LfcEvent event) {
        if (this.gisComposite == null) {
            return;
        }
        switch (event.getType()) {
            case GIS_CONTEXT: {
                this.gisComposite.displayContextMenu((GisLocation)((Object)event.getContext()));
                break;
            }
        }
    }
}

