/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dashboard;

import com.moonlit.logfaces.client.dashboard.Widget;
import com.moonlit.logfaces.client.dashboard.WidgetShell;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.options.RangeColorOption;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class WidgetViewCounter
extends WidgetShell {
    private Label label;
    private Font theFont;

    public WidgetViewCounter(Widget widget) {
        super(widget, widget.getDashboard().getDesktop());
    }

    @Override
    protected void createWidgetView() {
        Composite container = new Composite(this.getContentPane(), 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        int value = this.widget.getModel().getTotalCounts();
        Color fgColor = EventStyles.FG_LFS;
        RangeColorOption option = this.widget.getOption("rangeColors", RangeColorOption.class);
        if (option != null) {
            fgColor = option.getColor(value);
        }
        this.label = new Label(container, 0x1000800);
        this.label.setLayoutData((Object)new GridData(4, 4, true, true));
        this.label.setBackground(EventStyles.BG_LFS);
        this.label.setForeground(fgColor);
        this.label.setToolTipText("Double click to drill down");
        this.label.setText(String.format("%d", value));
        this.label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                WidgetViewCounter.this.widget.fetch();
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                WidgetViewCounter.this.adjustFont();
            }
        });
        this.widgetView = container;
    }

    @Override
    public void updateTitle() {
        this.setText(String.format("  %s", this.widget.getName()));
    }

    @Override
    public void display() {
        super.display();
        this.adjustFont();
    }

    @Override
    public void close(boolean remove) {
        if (this.theFont != null) {
            this.theFont.dispose();
        }
        this.theFont = null;
        super.close(remove);
    }

    protected void adjustFont() {
        if (this.label == null || this.label.isDisposed()) {
            return;
        }
        Rectangle rect = this.label.getBounds();
        int height = rect.height;
        int padding = height / 3;
        height -= padding;
        if (this.theFont != null) {
            this.theFont.dispose();
        }
        this.theFont = new Font((Device)Display.getDefault(), "Lucida Grande", height, 0);
        this.label.setFont(this.theFont);
        this.label.setText(String.format("%d", this.widget.getModel().getTotalCounts()));
    }
}

