/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dashboard;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.dashboard.Widget;
import com.moonlit.logfaces.client.dashboard.WidgetView;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.client.widgets.NoteComposite;
import com.novocode.ishell.DesktopForm;
import com.novocode.ishell.InternalShell;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class WidgetShell
extends InternalShell
implements WidgetView {
    protected Widget widget;
    protected NoteComposite note;
    protected Composite widgetView;
    protected DesktopForm desktop;

    public WidgetShell(Widget widget, DesktopForm desktop) {
        super(desktop, 66640);
        this.desktop = desktop;
        this.widget = widget;
        this.bounds = widget.getBounds();
        this.setImage(ImageHolder.getInstance().getImage(widget.getSliceInfo()));
        this.updateTitle();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        this.contentPane.setLayout((Layout)layout);
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                WidgetShell.this.rebound();
            }

            public void controlResized(ControlEvent e) {
                WidgetShell.this.rebound();
            }
        });
    }

    private void rebound() {
        if (this.isDisposed()) {
            return;
        }
        if (this.desktop.getParent() instanceof ScrolledComposite) {
            ScrolledComposite scrollable = (ScrolledComposite)this.desktop.getParent();
            Point point = this.desktop.computeSize(-1, -1);
            scrollable.setMinSize(point);
        }
    }

    public void updateTitle() {
        if (this.isDisposed()) {
            return;
        }
        if (this.widget.getModel().hasData()) {
            this.setText(String.format("  %s  (Events: %d, %s%s: %d)", this.widget.getName(), this.widget.getModel().getTotalCounts(), this.widget.getSliceInfo().getName(), this.widget.getSliceInfo().getName().endsWith("s") ? "" : "s", this.widget.getModel().getProjections().size()));
        } else {
            this.setText(String.format("  %s", this.widget.getName()));
        }
    }

    @Override
    public void fetch() {
        if (this.isDisposed()) {
            return;
        }
        this.widget.fetch();
    }

    @Override
    public void refresh() {
        if (this.isDisposed()) {
            return;
        }
        this.widget.refresh();
        this.updateTitle();
    }

    @Override
    public void setup() {
        if (this.isDisposed()) {
            return;
        }
        this.widget.setup();
        if (this.isDisposed()) {
            return;
        }
        this.updateTitle();
    }

    @Override
    public void open() {
        if (this.isDisposed()) {
            return;
        }
        super.open();
        this.setBounds(this.widget.getBounds());
        this.updateTitle();
    }

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public void close(boolean remove) {
        if (this.isDisposed()) {
            return;
        }
        if (remove) {
            if (!MessageDialog.openConfirm((Shell)Application.getShell(), (String)"Please confirm", (String)"Remove this widget from dashboard?")) {
                return;
            }
            this.widget.remove();
        }
        super.close();
    }

    @Override
    public void note(String text, boolean disable, boolean ok) {
        if (this.isDisposed()) {
            return;
        }
        Rectangle rect = new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        this.enableControls(!disable);
        this.cleanup();
        this.note = new NoteComposite(this.contentPane, text, ok ? "icons/message_info.gif" : "icons/task_warning_misc.gif");
        GridData gd = new GridData(2, 2, true, true, 1, 1);
        this.note.setLayoutData(gd);
        this.pack(true);
        this.setBounds(rect);
        if (disable) {
            this.setText(text);
        } else {
            this.setText(this.widget.getName());
        }
    }

    @Override
    public void display() {
        if (this.isDisposed()) {
            return;
        }
        Rectangle rect = new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        this.enableControls(true);
        this.cleanup();
        this.createWidgetView();
        GridData gd = new GridData(1808);
        this.widgetView.setLayoutData((Object)gd);
        this.pack(true);
        this.setBounds(rect);
        this.updateTitle();
    }

    @Override
    public boolean isMaximized() {
        return super.getMaximized();
    }

    @Override
    public void setMaximized(boolean maximized) {
        super.setMaximized(maximized);
        Utils.displayOneTimeTip("tip.dahsboard.max", "Press ESC to exit maximized preview\n\n(this message will not appear again)");
    }

    protected abstract void createWidgetView();

    private void cleanup() {
        if (this.note != null && !this.note.isDisposed()) {
            this.note.dispose();
        }
        if (this.widgetView != null && !this.widgetView.isDisposed()) {
            this.widgetView.dispose();
        }
        this.note = null;
        this.widgetView = null;
    }
}

