/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dashboard;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.moonlit.logfaces.client.dashboard.Widget;
import com.moonlit.logfaces.client.dashboard.WidgetModel;
import com.moonlit.logfaces.client.gis.GIS;
import com.moonlit.logfaces.client.gis.GisLocation;
import com.moonlit.logfaces.client.options.EnumOption;
import com.moonlit.logfaces.client.types.MaxContributors;
import com.moonlit.logfaces.server.vo.StatVO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.eclipse.swt.widgets.Display;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.SortOrder;

public class WidgetModelImpl
implements WidgetModel {
    private List<StatVO> model;
    private Widget widget;
    private long fromTime;
    private long toTime;

    public WidgetModelImpl(Widget widget) {
        this.widget = widget;
    }

    @Override
    public void setData(List<StatVO> stats, long fromTime, long toTime, boolean ok) {
        this.model = stats;
        this.fromTime = fromTime;
        this.toTime = toTime;
        Display.getDefault().asyncExec(() -> {
            if (ok) {
                try {
                    this.widget.update();
                }
                catch (Throwable e) {
                    LogManager.getLogger(WidgetModelImpl.class).error(e.getMessage(), e);
                }
                return;
            }
            this.widget.failed();
        });
    }

    @Override
    public PieDataset makePieDataset() {
        int maxSize;
        DefaultPieDataset dataset = new DefaultPieDataset();
        if (!this.hasData()) {
            return dataset;
        }
        for (StatVO vo : this.model) {
            dataset.setValue((Comparable)((Object)vo.getProjection()), (double)vo.getCount());
        }
        dataset.sortByValues(SortOrder.DESCENDING);
        EnumOption option = this.widget.getOption("maxContributors", EnumOption.class);
        int n = maxSize = option != null ? ((MaxContributors)((Object)option.getValue())).toNumber() : -1;
        if (maxSize > 0 && maxSize < dataset.getItemCount()) {
            ArrayList keys = Lists.newArrayList((Iterable)dataset.getKeys());
            keys.subList(maxSize, keys.size()).clear();
            for (Object key : dataset.getKeys()) {
                if (keys.contains(key)) continue;
                dataset.remove((Comparable)key);
            }
        }
        return dataset;
    }

    @Override
    public XYDataset makeTimeDataset() {
        TimeTableXYDataset dataset = new TimeTableXYDataset();
        if (!this.hasData()) {
            return dataset;
        }
        SimpleTimePeriod period = new SimpleTimePeriod(this.fromTime, this.fromTime + 1000L);
        dataset.add((TimePeriod)period, 0.0, (Comparable)((Object)""));
        for (StatVO vo : this.model) {
            period = new SimpleTimePeriod(vo.getT1(), vo.getT2());
            dataset.add((TimePeriod)period, (double)vo.getCount(), (Comparable)((Object)vo.getProjection()));
        }
        period = new SimpleTimePeriod(this.toTime - 1000L, this.toTime);
        dataset.add((TimePeriod)period, 0.0, (Comparable)((Object)""));
        return dataset;
    }

    @Override
    public boolean hasData() {
        return this.model != null;
    }

    @Override
    public int getTotalCounts() {
        if (this.model == null) {
            return 0;
        }
        int count = 0;
        for (StatVO vo : this.model) {
            count = (int)((float)count + vo.getCount());
        }
        return count;
    }

    @Override
    public Set<String> getProjections() {
        TreeSet set = Sets.newTreeSet();
        if (this.model == null) {
            return set;
        }
        for (StatVO vo : this.model) {
            set.add(vo.getProjection());
        }
        return set;
    }

    @Override
    public Set<GisLocation> makeLocations() {
        HashSet ips = Sets.newHashSet();
        for (StatVO vo : this.model) {
            ips.add(vo.getProjection());
        }
        return GIS.getInstance().resolve(ips, false);
    }
}

