/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dashboard;

import com.google.common.collect.Maps;
import com.moonlit.logfaces.client.dashboard.Dashboard;
import com.moonlit.logfaces.client.dashboard.SliceInfo;
import com.moonlit.logfaces.client.dashboard.Widget;
import com.moonlit.logfaces.client.dashboard.WidgetDialog;
import com.moonlit.logfaces.client.dashboard.WidgetModel;
import com.moonlit.logfaces.client.dashboard.WidgetModelImpl;
import com.moonlit.logfaces.client.dashboard.WidgetType;
import com.moonlit.logfaces.client.dashboard.WidgetView;
import com.moonlit.logfaces.client.dashboard.WidgetViewCounter;
import com.moonlit.logfaces.client.dashboard.WidgetViewGis;
import com.moonlit.logfaces.client.dashboard.WidgetViewList;
import com.moonlit.logfaces.client.dashboard.WidgetViewPie;
import com.moonlit.logfaces.client.dashboard.WidgetViewTimeline;
import com.moonlit.logfaces.client.gis.GIS;
import com.moonlit.logfaces.client.jobs.FetchQueryJob;
import com.moonlit.logfaces.client.jobs.QueryDataFetcher;
import com.moonlit.logfaces.client.jobs.WidgetJob;
import com.moonlit.logfaces.client.model.ComponentsModel;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.model.RegexModel;
import com.moonlit.logfaces.client.model.RegexVO;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.options.EnumOption;
import com.moonlit.logfaces.client.options.Option;
import com.moonlit.logfaces.client.options.RangeColorOption;
import com.moonlit.logfaces.client.options.ScalarOption;
import com.moonlit.logfaces.client.types.MaxContributors;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.stats.StatCategory;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IMemento;
import org.jfree.data.time.TimePeriod;

public class WidgetImpl
implements Widget {
    private Dashboard dashboard;
    private String name = "";
    private CriteriaFilter criteria;
    private WidgetType type;
    private SliceInfo sliceInfo;
    private WidgetModel model;
    private Rectangle bounds;
    private WidgetView view;
    private Map<String, Option> options;
    private static final Logger log = LogManager.getLogger(WidgetImpl.class);

    public WidgetImpl(Dashboard dashboard) {
        this.dashboard = dashboard;
        this.name = "";
        this.type = WidgetType.slice;
        this.sliceInfo = new SliceInfo(StatCategory.attributes, EventAttribute.loggerLevel, "Levels");
        this.criteria = new JexlCriteria();
        this.bounds = new Rectangle(10, 10, 450, 350);
        this.model = new WidgetModelImpl(this);
        this.options = Maps.newHashMap();
    }

    @Override
    public WidgetView getView() {
        return this.view;
    }

    @Override
    public WidgetModel getModel() {
        return this.model;
    }

    @Override
    public Widget clone() {
        WidgetImpl other = new WidgetImpl(this.dashboard);
        other.name = this.name;
        other.criteria = this.criteria.clone();
        other.sliceInfo = new SliceInfo(this.sliceInfo);
        other.bounds = new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        other.type = this.type;
        return other;
    }

    @Override
    public void open() {
        switch (this.type) {
            case slice: {
                this.view = new WidgetViewPie(this);
                break;
            }
            case distribution: {
                this.view = new WidgetViewTimeline(this);
                break;
            }
            case list: {
                this.view = new WidgetViewList(this);
                break;
            }
            case counter: {
                this.view = new WidgetViewCounter(this);
                break;
            }
            case gis: {
                this.view = new WidgetViewGis(this);
                break;
            }
            default: {
                this.view = new WidgetViewPie(this);
            }
        }
        this.view.open();
        this.refresh();
    }

    @Override
    public void close() {
        if (this.view == null) {
            return;
        }
        if (!this.view.isMaximized()) {
            this.bounds = this.view.getBounds();
        }
        this.view.close(false);
    }

    @Override
    public void remove() {
        this.close();
        this.dashboard.remove(this);
    }

    @Override
    public void refresh() {
        if (this.view == null) {
            return;
        }
        this.view.note("getting data, please stand by", true, true);
        WidgetJob job = new WidgetJob(this);
        job.setUser(true);
        job.schedule();
    }

    @Override
    public void update() {
        if (this.model.hasData() && this.model.getTotalCounts() > 0) {
            this.view.display();
        } else {
            this.view.note("no data", false, true);
        }
    }

    @Override
    public void failed() {
        this.view.note("failed getting data from server", false, false);
    }

    @Override
    public void drill(TimePeriod period, String series) {
        if (period == null) {
            period = this.dashboard.getRange().toTimePeriod();
        }
        QueryVO query = new QueryVO();
        query.setName(String.format("%s (%s)", this.name, series));
        query.setTimeRange(TimeRange.CUSTOM_RANGE, period.getStart().getTime(), period.getEnd().getTime());
        query.setLimit(-1);
        this.sliceInfo.setSeries(series);
        query.setCriteria(Utils.makeDrillcriteria(this.sliceInfo, this.criteria.clone()));
        FetchQueryJob job = new FetchQueryJob(new QueryDataFetcher(query, true));
        job.setUser(true);
        job.schedule();
    }

    @Override
    public void fetch() {
        QueryVO query = new QueryVO();
        query.setName(this.name);
        long from = this.dashboard.getRange().getTime(true, System.currentTimeMillis());
        long until = this.dashboard.getRange().getTime(false, System.currentTimeMillis());
        query.setTimeRange(TimeRange.CUSTOM_RANGE, from, until);
        query.setLimit(-1);
        query.setCriteria(this.criteria.clone());
        FetchQueryJob job = new FetchQueryJob(new QueryDataFetcher(query, true));
        job.setUser(true);
        job.schedule();
    }

    @Override
    public void load(IMemento memento) {
        IMemento m;
        this.name = memento.getString("name");
        this.type = WidgetType.values()[memento.getInteger("type")];
        this.bounds = new Rectangle(10, 10, 450, 350);
        this.sliceInfo = new SliceInfo();
        this.sliceInfo.load(memento);
        this.criteria = Utils.unserializeCriteria(memento);
        IMemento[] iMementoArray = memento.getChildren("option");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            m = iMementoArray[n2];
            try {
                String cname = m.getString("class");
                if (cname != null) {
                    Class<?> cls = Class.forName(cname);
                    Option option = (Option)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    option.load(m);
                    this.options.put(option.getName(), option);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
        m = memento.getChild("view");
        if (memento != null) {
            this.bounds.x = m.getInteger("x");
            this.bounds.y = m.getInteger("y");
            this.bounds.width = m.getInteger("w");
            this.bounds.height = m.getInteger("h");
        }
    }

    @Override
    public void save(IMemento parent) {
        IMemento memento = parent.createChild("widget");
        memento.putString("name", this.name);
        memento.putInteger("type", this.type.ordinal());
        for (Option option : this.options.values()) {
            option.save(memento);
        }
        this.sliceInfo.save(memento);
        Utils.serializeCriteria(memento, this.criteria);
        IMemento m = memento.createChild("view");
        m.putInteger("x", this.bounds.x);
        m.putInteger("y", this.bounds.y);
        m.putInteger("w", this.bounds.width);
        m.putInteger("h", this.bounds.height);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setType(WidgetType type) {
        this.type = type;
        this.ensureOptions();
    }

    @Override
    public WidgetType getType() {
        return this.type;
    }

    @Override
    public void setup() {
        WidgetDialog dialog = new WidgetDialog(this.view.getShell(), this);
        if (dialog.open() == 0) {
            this.close();
            this.open();
        }
    }

    @Override
    public Map<String, Object> buildQuery() {
        HashMap params = Maps.newHashMap();
        TimeRange range = this.dashboard.getRange();
        long from = range.getTime(true, System.currentTimeMillis());
        long until = range.getTime(false, System.currentTimeMillis());
        params.put("fromTime", from);
        params.put("toTime", until);
        params.put("size", -1);
        params.put("criteria", this.criteria);
        params.put("statcategory", this.sliceInfo.getType());
        params.put("attribute", this.sliceInfo.getAttribute());
        params.put("statrate", this.type == WidgetType.distribution ? (until - from) / 90L : 0L);
        if (this.type == WidgetType.gis) {
            params.put("regex", "%{IP:ip}");
            return params;
        }
        if (this.sliceInfo.isOfComponents()) {
            params.put("components", ComponentsModel.getInstance().toMap());
        } else if (this.sliceInfo.isOfTags()) {
            params.put("tags", TagsModel.getInstance().toCriteriaMap());
        } else if (this.sliceInfo.isOfMdc()) {
            params.put("mdc", this.sliceInfo.getName());
        } else if (this.sliceInfo.isOfRegex() || this.sliceInfo.isOfIntegral()) {
            RegexVO rxvo = RegexModel.getInstance().get(this.sliceInfo.getName());
            params.put("regex", rxvo.getExpression());
            params.put("regexGroup", rxvo.getGroup());
            params.put("regexName", rxvo.getName());
        }
        return params;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public CriteriaFilter getCriteria() {
        return this.criteria;
    }

    @Override
    public void setCriteria(CriteriaFilter criteria) {
        this.criteria = criteria;
    }

    @Override
    public SliceInfo getSliceInfo() {
        return this.sliceInfo;
    }

    @Override
    public void setSliceInfo(SliceInfo sliceInfo) {
        this.sliceInfo = this.type == WidgetType.gis ? new SliceInfo(StatCategory.regex, EventAttribute.message, "GIS") : sliceInfo;
    }

    @Override
    public Dashboard getDashboard() {
        return this.dashboard;
    }

    @Override
    public void setDashboard(Dashboard dashboard) {
        this.dashboard = dashboard;
    }

    @Override
    public Map<String, Option> getOptions() {
        return this.options;
    }

    @Override
    public <T extends Option> T getOption(String name, Class<T> type) {
        Option option = this.options.get(name);
        if (option == null) {
            return null;
        }
        if (option.getClass().equals(type)) {
            return (T)option;
        }
        return null;
    }

    protected void ensureOptions() {
        switch (this.type) {
            case slice: {
                this.options.remove("rangeColors");
                if (this.options.containsKey("maxContributors")) break;
                EnumOption<MaxContributors> option = new EnumOption<MaxContributors>("maxContributors", "", MaxContributors.ALL);
                this.options.put(option.getName(), option);
                break;
            }
            case counter: {
                this.options.remove("maxContributors");
                if (this.options.containsKey("rangeColors")) break;
                RangeColorOption option = new RangeColorOption("rangeColors", "Foreground colors based on counter thresholds:", 3);
                this.options.put(option.getName(), option);
                break;
            }
            case gis: {
                this.options.clear();
                this.options.put("zoom", new ScalarOption("zoom", GIS.getInstance().getLastZoom()));
                this.options.put("lat", new ScalarOption("lat", GIS.getInstance().getLastLat()));
                this.options.put("lon", new ScalarOption("lon", GIS.getInstance().getLastLon()));
                break;
            }
            default: {
                this.options.clear();
            }
        }
    }
}

