/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dashboard;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.dashboard.SliceInfo;
import com.moonlit.logfaces.client.dashboard.Widget;
import com.moonlit.logfaces.client.dashboard.WidgetType;
import com.moonlit.logfaces.client.options.OptionsDialog;
import com.moonlit.logfaces.client.widgets.CriteriaComposite;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.stats.StatCategory;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WidgetDialog
extends Dialog {
    private CriteriaComposite criteriaComposite;
    private Widget widget;
    private ComboViewer typeCombo;
    private ComboViewer catCombo;
    private Text widgetName;
    private Link optionsLink;

    public WidgetDialog(Shell parent, Widget widget) {
        super(parent);
        this.widget = widget;
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        container.setLayout((Layout)gridLayout);
        Label label = new Label(container, 0);
        label.setText("Name");
        label.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.widgetName = new Text(container, 2048);
        this.widgetName.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        this.widgetName.setText(this.widget.getName());
        this.widgetName.setEnabled(true);
        this.typeCombo = new ComboViewer(container, 8);
        this.typeCombo.addSelectionChangedListener((ISelectionChangedListener)new TypeSelector());
        this.typeCombo.getCombo().setToolTipText("Type of the widget to display");
        this.typeCombo.getCombo().setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.typeCombo.getCombo().setVisibleItemCount(WidgetType.values().length);
        this.typeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.typeCombo.setInput((Object)WidgetType.values());
        this.typeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return super.getText((Object)element.toString());
            }
        });
        this.typeCombo.setSelection((ISelection)new StructuredSelection((Object)this.widget.getType()));
        this.catCombo = new ComboViewer(container, 8);
        this.catCombo.getCombo().setToolTipText("Log data category to display");
        this.catCombo.getCombo().setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.catCombo.getCombo().setVisibleItemCount(30);
        this.catCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.catCombo.setInput((Object)SliceInfo.getAll(true).toArray());
        this.catCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return super.getText((Object)element.toString());
            }
        });
        this.catCombo.setSelection((ISelection)new StructuredSelection((Object)this.widget.getSliceInfo()));
        this.catCombo.getControl().setEnabled(this.widget.getType() != WidgetType.counter && this.widget.getType() != WidgetType.gis);
        this.catCombo.getControl().setVisible(this.widget.getType() != WidgetType.counter && this.widget.getType() != WidgetType.gis);
        this.optionsLink = new Link(container, 0);
        this.optionsLink.setForeground(new Color(null, 0, 0, 255));
        this.optionsLink.setLayoutData((Object)new GridData(3, 4, false, false, 1, 1));
        this.optionsLink.addMouseListener((MouseListener)new OptionsLinkListener());
        this.optionsLink.setText("<a>Display options</a>");
        this.optionsLink.setToolTipText("Additional options for rendering the widget");
        this.optionsLink.setVisible(!this.widget.getOptions().isEmpty() && this.widget.getType() != WidgetType.gis);
        label = new Label(container, 258);
        label.setText("");
        label.setLayoutData((Object)new GridData(4, 2, false, false, 5, 1));
        label = new Label(container, 0);
        label.setText("Use this criteria to fetch log data:");
        label.setLayoutData((Object)new GridData(4, 2, false, false, 5, 1));
        this.criteriaComposite = new CriteriaComposite(container, this.widget.getCriteria().clone());
        this.criteriaComposite.setLayoutData(new GridData(4, 4, true, true, 5, 1));
        this.criteriaComposite.setFocus();
        this.getShell().setMinimumSize(600, 500);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Dashboard widget");
        newShell.setImage(ImageHolder.getInstance().getImage("icons/query.gif"));
    }

    protected void okPressed() {
        CriteriaFilter criteria = this.criteriaComposite.getCriteria();
        this.widget.setName(this.widgetName.getText());
        this.widget.setType((WidgetType)((Object)((IStructuredSelection)this.typeCombo.getSelection()).getFirstElement()));
        this.widget.setSliceInfo((SliceInfo)((IStructuredSelection)this.catCombo.getSelection()).getFirstElement());
        this.widget.setCriteria(criteria);
        super.okPressed();
    }

    class OptionsLinkListener
    extends MouseAdapter {
        OptionsLinkListener() {
        }

        public void mouseDown(MouseEvent e) {
            ArrayList options = Lists.newArrayList(WidgetDialog.this.widget.getOptions().values());
            OptionsDialog dlg = new OptionsDialog(WidgetDialog.this.getShell(), "Display options", options);
            dlg.open();
        }
    }

    class TypeSelector
    implements ISelectionChangedListener {
        TypeSelector() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (WidgetDialog.this.typeCombo.getSelection().isEmpty()) {
                return;
            }
            WidgetType type = (WidgetType)((Object)((IStructuredSelection)WidgetDialog.this.typeCombo.getSelection()).getFirstElement());
            if (type == WidgetType.counter && WidgetDialog.this.catCombo != null) {
                SliceInfo si = new SliceInfo(StatCategory.attributes, EventAttribute.loggerLevel, "Levels");
                WidgetDialog.this.catCombo.setSelection((ISelection)new StructuredSelection((Object)si));
            }
            if (WidgetDialog.this.catCombo != null) {
                WidgetDialog.this.catCombo.getControl().setEnabled(type != WidgetType.counter && type != WidgetType.gis);
                WidgetDialog.this.catCombo.getControl().setVisible(type != WidgetType.counter && type != WidgetType.gis);
            }
            if (WidgetDialog.this.optionsLink != null) {
                boolean hasOptions = !WidgetDialog.this.widget.getOptions().isEmpty();
                WidgetDialog.this.optionsLink.setText(hasOptions ? "<a>Display options</a>" : "");
                WidgetDialog.this.optionsLink.setVisible(hasOptions && type != WidgetType.gis);
            }
        }
    }
}

