/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dashboard;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.model.RegexModel;
import com.moonlit.logfaces.client.model.RegexVO;
import com.moonlit.logfaces.client.net.ConnectionProfile;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.server.conf.MdcMap;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.stats.StatCategory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IMemento;

public class SliceInfo
implements Persistent {
    private StatCategory type = StatCategory.attributes;
    private EventAttribute attribute = EventAttribute.domainName;
    private String name = "Domains";
    private String series;

    public SliceInfo() {
    }

    public SliceInfo(SliceInfo other) {
        this.type = other.type;
        this.attribute = other.attribute;
        this.name = other.name;
    }

    public SliceInfo(StatCategory type, EventAttribute attribute, String name) {
        this.type = type;
        this.attribute = attribute;
        this.name = name;
    }

    public String toString() {
        switch (this.type) {
            case mdc: {
                return String.format("(mdc) %s", this.name);
            }
            case regex: 
            case integral: {
                return String.format("(regex) %s", this.name);
            }
        }
        return this.name;
    }

    public boolean equals(Object other) {
        if (other instanceof SliceInfo) {
            return ((SliceInfo)other).getName().equals(this.name);
        }
        return false;
    }

    public StatCategory getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isOfComponents() {
        return this.type == StatCategory.components;
    }

    public boolean isOfTags() {
        return this.type == StatCategory.tags;
    }

    public boolean isOfRegex() {
        return this.type == StatCategory.regex;
    }

    public boolean isOfIntegral() {
        return this.type == StatCategory.integral;
    }

    public boolean isOfMdc() {
        return this.type == StatCategory.mdc;
    }

    public RegexVO getRegex() {
        return this.isOfRegex() || this.isOfIntegral() ? RegexModel.getInstance().get(this.name) : null;
    }

    public static List<SliceInfo> getAll(boolean db) {
        ArrayList list = Lists.newArrayList();
        list.add(new SliceInfo(StatCategory.attributes, EventAttribute.domainName, "Applications"));
        list.add(new SliceInfo(StatCategory.attributes, EventAttribute.hostName, "Hosts"));
        list.add(new SliceInfo(StatCategory.attributes, EventAttribute.loggerLevel, "Levels"));
        list.add(new SliceInfo(StatCategory.attributes, EventAttribute.throwableInfo, "Exceptions"));
        list.add(new SliceInfo(StatCategory.attributes, EventAttribute.loggerName, "Loggers"));
        list.add(new SliceInfo(StatCategory.attributes, EventAttribute.threadName, "Threads"));
        list.add(new SliceInfo(StatCategory.components, EventAttribute.loggerName, "Components"));
        list.add(new SliceInfo(StatCategory.tags, EventAttribute.message, "Tags"));
        for (String mdcName : MdcMap.getNames()) {
            if (!StringUtils.hasText(mdcName)) continue;
            list.add(new SliceInfo(StatCategory.mdc, EventAttribute.mdc, mdcName));
        }
        if (!db || ConnectionProfile.getInstance().isDbRegexSupported()) {
            for (RegexVO rxvo : RegexModel.getInstance().getRegexes()) {
                list.add(new SliceInfo(rxvo.isNumeric() ? StatCategory.integral : StatCategory.regex, EventAttribute.message, rxvo.getName()));
            }
        }
        return list;
    }

    public EventAttribute getAttribute() {
        return this.attribute;
    }

    @Override
    public void load(IMemento parent) {
        if (parent == null) {
            return;
        }
        IMemento memento = parent.getChild("sliceInfo");
        this.name = memento.getString("name");
        this.attribute = EventAttribute.valueOf((String)memento.getString("attribute"));
        this.type = StatCategory.valueOf((String)memento.getString("type"));
    }

    @Override
    public void save(IMemento parent) {
        IMemento m = parent.createChild("sliceInfo");
        m.putString("name", this.name);
        m.putString("attribute", this.attribute.name());
        m.putString("type", this.type.name());
    }

    public String getSeries() {
        return this.series;
    }

    public void setSeries(String series) {
        this.series = series;
    }
}

