/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dashboard;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.dashboard.Dashboard;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.server.util.LfsEventBus;
import java.util.List;
import org.eclipse.ui.IMemento;

public class DashboardsModel
extends ContextElement
implements Persistent {
    private List<Dashboard> dashboards = Lists.newArrayList();
    private static DashboardsModel instance;
    private String lastUsed;

    public static DashboardsModel getInstance() {
        if (instance == null) {
            instance = new DashboardsModel();
        }
        return instance;
    }

    public Dashboard getDashboard(String name) {
        for (Dashboard d : this.dashboards) {
            if (!d.getName().equals(name)) continue;
            return d;
        }
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public ContextElement getParent() {
        return null;
    }

    @Override
    protected void fireContextChanged() {
        LfsEventBus.getInstance().post((Object)LfcEvent.dashboardsModel());
    }

    public List<Dashboard> getDashboards() {
        return Lists.newArrayList(this.dashboards);
    }

    public Dashboard add(String name) {
        Dashboard dashboard = new Dashboard(name);
        this.dashboards.add(dashboard);
        this.fireContextChanged();
        return dashboard;
    }

    public Dashboard clone(String name, String newName) {
        Dashboard dashboard = this.getDashboard(name);
        if (dashboard == null) {
            return null;
        }
        Dashboard clone = dashboard.clone();
        clone.setName(newName);
        this.dashboards.add(clone);
        return clone;
    }

    public void rename(String name, String newName) {
        Dashboard d = this.getDashboard(name);
        if (d != null) {
            d.setName(newName);
            if (name.equals(this.lastUsed)) {
                this.lastUsed = newName;
            }
            this.fireContextChanged();
        }
    }

    public void remove(String name) {
        Dashboard d = this.getDashboard(name);
        if (d != null) {
            this.dashboards.remove(d);
            this.fireContextChanged();
        }
    }

    public ContextElement[] getEntries() {
        if (this.dashboards != null) {
            return this.dashboards.toArray(new ContextElement[this.dashboards.size()]);
        }
        return new ContextElement[0];
    }

    public void clear() {
        this.dashboards.clear();
    }

    public boolean isEmpty() {
        return this.dashboards.isEmpty();
    }

    @Override
    public void load(IMemento parent) {
        this.clear();
        if (parent == null) {
            return;
        }
        IMemento memento = parent.getChild("dashboards");
        if (memento == null) {
            return;
        }
        this.lastUsed = memento.getString("lastUsed");
        IMemento[] iMementoArray = memento.getChildren("dashboard");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento m = iMementoArray[n2];
            Dashboard dashboard = new Dashboard();
            dashboard.load(m);
            this.dashboards.add(dashboard);
            ++n2;
        }
    }

    @Override
    public void save(IMemento parent) {
        if (parent == null) {
            return;
        }
        IMemento memento = parent.createChild("dashboards");
        memento.putString("lastUsed", this.lastUsed != null ? this.lastUsed : "");
        for (Dashboard dashboard : this.dashboards) {
            dashboard.save(memento);
        }
    }

    public String getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(String lastUsed) {
        this.lastUsed = lastUsed;
    }
}

