/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dashboard;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.dashboard.DashboardsModel;
import com.moonlit.logfaces.client.dashboard.Widget;
import com.moonlit.logfaces.client.dashboard.WidgetImpl;
import com.moonlit.logfaces.client.model.ContextElement;
import com.moonlit.logfaces.client.types.Direction;
import com.moonlit.logfaces.client.types.TimeRange;
import com.novocode.ishell.DesktopForm;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;

public class Dashboard
extends ContextElement
implements Persistent,
Cloneable {
    private DesktopForm desktop;
    private String name = "";
    private Timer timer;
    private List<Widget> widgets = Lists.newArrayList();
    private TimeRange range = TimeRange.BEFORE_4_HOURS;
    private static final Logger log = LogManager.getLogger(Dashboard.class);

    public Dashboard() {
    }

    public Dashboard(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Dashboard)) {
            return false;
        }
        Dashboard other = (Dashboard)o;
        return this.name.equals(other.name);
    }

    public String toString() {
        return this.name;
    }

    public Dashboard clone() {
        Dashboard other = new Dashboard();
        other.name = this.name;
        other.range = this.range;
        for (Widget widget : this.widgets) {
            Widget wc = widget.clone();
            wc.setDashboard(other);
            other.widgets.add(wc);
        }
        return other;
    }

    public void display(DesktopForm desktop) {
        this.desktop = desktop;
        for (Widget widget : this.widgets) {
            widget.open();
        }
        this.setTimer();
    }

    public void close() {
        this.stopTimer();
        for (Widget widget : this.widgets) {
            widget.close();
        }
    }

    public void add(Widget widget) {
        this.widgets.add(widget);
    }

    public void remove(Widget widget) {
        this.widgets.remove(widget);
    }

    public void clear() {
        for (Widget widget : this.widgets) {
            widget.close();
        }
        this.widgets.clear();
    }

    public void refresh() {
        for (Widget widget : this.widgets) {
            widget.refresh();
        }
    }

    @Override
    public ContextElement getParent() {
        return DashboardsModel.getInstance();
    }

    @Override
    protected void fireContextChanged() {
    }

    @Override
    public void load(IMemento memento) {
        this.name = memento.getString("name");
        this.range = TimeRange.values()[memento.getInteger("range")];
        if (TimeRange.PARTICULAR_DAY == this.range) {
            try {
                long from = Long.parseLong(memento.getString("fromTime"));
                long until = Long.parseLong(memento.getString("toTime"));
                this.range.setCustomRange(from, until);
            }
            catch (Exception from) {
                // empty catch block
            }
        }
        IMemento[] iMementoArray = memento.getChildren("widget");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento m = iMementoArray[n2];
            WidgetImpl widget = new WidgetImpl(this);
            widget.load(m);
            this.widgets.add(widget);
            ++n2;
        }
    }

    @Override
    public void save(IMemento parent) {
        IMemento memento = parent.createChild("dashboard");
        memento.putString("name", this.name);
        memento.putInteger("range", this.range.ordinal());
        long now = System.currentTimeMillis();
        memento.putString("fromTime", "" + this.range.getTime(true, now));
        memento.putString("toTime", "" + this.range.getTime(false, now));
        for (Widget widget : this.widgets) {
            widget.save(memento);
        }
    }

    private void setTimer() {
        this.stopTimer();
        try {
            this.timer = new Timer();
            this.timer.start();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void stopTimer() {
        try {
            if (this.timer != null) {
                this.timer.interrupt();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public TimeRange getRange() {
        return this.range;
    }

    public void setRange(TimeRange range) {
        this.range = range;
        this.setTimer();
    }

    public void page(Direction direction) {
        long span = this.range.getRange() * (long)direction.toMultiplier();
        long from = this.range.getTime(true) + span;
        long until = this.range.getTime(false) + span;
        this.range = TimeRange.CUSTOM_RANGE;
        this.range.setCustomRange(from, until);
        this.refresh();
    }

    public void setName(String name) {
        this.name = name;
    }

    public DesktopForm getDesktop() {
        return this.desktop;
    }

    class Timer
    extends Thread {
        private long slept;

        Timer() {
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Thread.sleep(120000L);
                    ++this.slept;
                    if (this.slept < Dashboard.this.range.getRange() / 3600000L) continue;
                    this.slept = 0L;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Dashboard.this.refresh();
                        }
                    });
                }
                catch (Exception e) {
                    break;
                }
            }
        }
    }
}

