/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.google.common.eventbus.Subscribe;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.dialogs.ListSelectionDialog;
import com.moonlit.logfaces.client.model.ChoiceModel;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.util.LfsEventBus;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class TidyWorkspacesAction
extends Action {
    WorkspaceHolder wsh = WorkspaceHolder.getInstance();

    public TidyWorkspacesAction() {
        this.setText("Tidy up workspaces...");
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/eclipse3_clear.gif"));
        LfsEventBus.getInstance().register((Object)this);
    }

    public boolean isEnabled() {
        return this.wsh.getNames().size() > 1;
    }

    @Subscribe
    public void handleLfcEvent(LfcEvent event) {
        if (event.is(LfcEvent.TYPE.WORKSPACE_LOADED) || event.is(LfcEvent.TYPE.WORKSPACE_REMOVED)) {
            this.setEnabled(this.wsh.getNames().size() > 1);
        }
    }

    public void run() {
        Collection<String> names = this.wsh.getNames();
        names.remove(this.wsh.getCurrentWorkspace().getName());
        if (names.isEmpty()) {
            Utils.displayWarning("Nothing to do", "Current workspace can't be removed");
            return;
        }
        ChoiceModel choice = new ChoiceModel(names);
        ListSelectionDialog dialog = new ListSelectionDialog("Select worskpaces to remove", "icons/dashboard.gif", choice, false);
        if (dialog.open() != 0) {
            return;
        }
        String[] choices = choice.getSelectionAsString();
        if (choices.length == 0) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)Application.getShell(), (String)"Please confirm", (String)"Selected workspaces and their files will be permanently removed from this computer.\nProceed?")) {
            return;
        }
        String[] stringArray = choices;
        int n = choices.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.wsh.remove(name);
            ++n2;
        }
    }
}

