/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.dialogs.TagDialog;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class TagAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private TagVO tag;
    private boolean remove;

    public TagAction(LogView view) {
        super("Create tag");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/tag.gif"));
        this.tag = new TagVO();
        this.tag.setName("tagName");
        this.tag.setColor(Display.getCurrent().getSystemColor(6));
        Table table = view.getTableViewer().getTable();
        TableItem item = table.getItem(table.getSelectionIndex());
        LoggingEventVO event = (LoggingEventVO)item.getData();
        JexlCriteria criteria = new JexlCriteria();
        if (event != null) {
            criteria.addRule().addCondition((Object)EventAttribute.message, (Object)Operation.contains, (Object)event.getMessage());
        }
        this.tag.setCriteria((CriteriaFilter)criteria);
    }

    public TagAction(TagVO tag, boolean remove) {
        super(String.format(remove ? "Remove tag '%s'" : "Modify tag '%s'", tag.getName()));
        this.remove = remove;
        this.tag = tag.clone();
        this.setImageDescriptor(MainPlugin.getImageDescriptor(remove ? "icons/eclipse3_remove.gif" : "icons/tag.gif"));
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        if (this.remove) {
            if (!MessageDialog.openQuestion((Shell)window.getShell(), (String)"Please confirm", (String)String.format("Delete the '%s' tag ?", this.tag.getName()))) {
                return;
            }
            TagsModel model = TagsModel.getInstance();
            model.remove(this.tag.getName());
            model.fireContextChanged();
            return;
        }
        TagDialog dialog = new TagDialog(window.getShell(), this.tag);
        dialog.open();
    }

    public void dispose() {
    }
}

