/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.google.common.eventbus.Subscribe;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.util.LfsEventBus;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class SwitchWorkspaceAction
extends Action
implements IMenuCreator {
    private Menu fMenu;
    private WorkspaceHolder wsh = WorkspaceHolder.getInstance();
    private List<ActionContributionItem> items = new ArrayList<ActionContributionItem>();
    private static final Logger log = LogManager.getLogger(SwitchWorkspaceAction.class);

    public SwitchWorkspaceAction() {
        super("Switch workspace", 4);
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setMenuCreator(this);
        LfsEventBus.getInstance().register((Object)this);
    }

    @Subscribe
    public void handleLfcEvent(LfcEvent event) {
        if (event.is(LfcEvent.TYPE.WORKSPACE_LOADED) || event.is(LfcEvent.TYPE.WORKSPACE_REMOVED)) {
            this.repopulate();
            this.setEnabled(this.wsh.getNames().size() > 1);
        }
    }

    public boolean isEnabled() {
        return this.wsh.getNames().size() > 1;
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        this.fMenu = new Menu(parent);
        for (String name : this.wsh.getNames()) {
            ActionContributionItem item = new ActionContributionItem((IAction)new SwitchAction(name));
            item.fill(this.fMenu, -1);
            this.items.add(item);
        }
        return this.fMenu;
    }

    public void repopulate() {
        for (ActionContributionItem item : this.items) {
            item.dispose();
        }
        for (String name : this.wsh.getNames()) {
            ActionContributionItem item = new ActionContributionItem((IAction)new SwitchAction(name));
            item.fill(this.fMenu, -1);
            this.items.add(item);
        }
    }

    public void dispose() {
        this.fMenu.dispose();
    }

    public void run() {
    }

    class SwitchAction
    extends Action {
        private final String name;

        public SwitchAction(String name) {
            this.name = name;
            this.setText(name);
            this.setChecked(name.equals(WorkspaceHolder.getInstance().getCurrentWorkspace().getName()));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            Utils.saveLogEditorStates();
            Utils.closeAllEditors();
            LfsConnector.getInstance().terminate();
            try {
                WorkspaceHolder.getInstance().switchTo(this.name);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                MessageDialog.openError((Shell)Application.getShell(), (String)"Error", (String)("Unable to switch workspace: " + e.getMessage()));
            }
        }
    }
}

