/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public class StatusLineContribution
extends ContributionItem {
    public static final int DEFAULT_CHAR_WIDTH = 40;
    private CLabel label;
    private Image image;
    private Image originalImage;
    private String text = "";
    private String originalText;
    private int widthHint = -1;
    private int heightHint = -1;
    private Listener listener;
    private int eventType;
    private String tooltip;
    private Timer timer;

    public StatusLineContribution(String id) {
        this(id, 40);
    }

    public StatusLineContribution(String id, int charWidth) {
        super(id);
        this.widthHint = charWidth;
        this.setVisible(false);
    }

    public void fill(Composite parent) {
        Label sep = new Label(parent, 2);
        this.label = new CLabel(parent, 32);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fm = gc.getFontMetrics();
        Point extent = gc.textExtent(this.text);
        this.widthHint = this.widthHint > 0 ? (int)fm.getAverageCharacterWidth() * this.widthHint : extent.x;
        this.heightHint = fm.getHeight();
        gc.dispose();
        StatusLineLayoutData statusLineLayoutData = new StatusLineLayoutData();
        statusLineLayoutData.widthHint = this.widthHint;
        statusLineLayoutData.heightHint = this.heightHint;
        this.label.setLayoutData((Object)statusLineLayoutData);
        this.label.setText(this.text);
        this.label.setImage(this.image);
        if (this.listener != null) {
            this.label.addListener(this.eventType, this.listener);
        }
        if (this.tooltip != null) {
            this.label.setToolTipText(this.tooltip);
        }
        statusLineLayoutData = new StatusLineLayoutData();
        statusLineLayoutData.heightHint = this.heightHint;
        sep.setLayoutData((Object)statusLineLayoutData);
    }

    public void addListener(int eventType, Listener listener) {
        this.eventType = eventType;
        this.listener = listener;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        this.text = text;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setText(this.text);
        }
        if (this.text.length() == 0) {
            if (this.isVisible()) {
                this.setVisible(false);
                IContributionManager contributionManager = this.getParent();
                if (contributionManager != null) {
                    contributionManager.update(true);
                }
            }
        } else if (!this.isVisible()) {
            this.setVisible(true);
            IContributionManager contributionManager = this.getParent();
            if (contributionManager != null) {
                contributionManager.update(true);
            }
        }
    }

    public void setTooltip(String tooltip) {
        if (tooltip == null) {
            throw new NullPointerException();
        }
        this.tooltip = tooltip;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setToolTipText(this.tooltip);
        }
    }

    public void setImage(Image image) {
        this.image = image;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setImage(this.image);
        }
        if (!this.isVisible()) {
            this.setVisible(true);
            IContributionManager contributionManager = this.getParent();
            if (contributionManager != null) {
                contributionManager.update(true);
            }
        }
    }

    public void blink(String text, Image image) {
        this.setText(text);
        this.setImage(image);
        if (this.timer == null) {
            this.originalImage = image;
            this.originalText = text;
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new BlinkTask(), 300L);
        }
    }

    public void stopBlink(String text, Image image) {
        this.setText(text);
        this.setImage(image);
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    class BlinkTask
    extends TimerTask {
        BlinkTask() {
        }

        @Override
        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (((BlinkTask)BlinkTask.this).StatusLineContribution.this.timer == null) {
                        StatusLineContribution.this.setImage(null);
                        StatusLineContribution.this.setText(" ");
                        return;
                    }
                    StatusLineContribution.this.setImage(((BlinkTask)BlinkTask.this).StatusLineContribution.this.image == null ? ((BlinkTask)BlinkTask.this).StatusLineContribution.this.originalImage : null);
                    StatusLineContribution.this.setText(((BlinkTask)BlinkTask.this).StatusLineContribution.this.image == null ? ((BlinkTask)BlinkTask.this).StatusLineContribution.this.originalText : " ");
                    ((BlinkTask)BlinkTask.this).StatusLineContribution.this.timer.schedule((TimerTask)new BlinkTask(), 300L);
                }
            });
        }
    }
}

