/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.editors.SupportEditor;
import com.moonlit.logfaces.client.editors.SupportInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ShowSupportAction
extends Action
implements IAction {
    public ShowSupportAction() {
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setText("&Report bug / request feature");
        this.setToolTipText("Open support ticket");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/level_debug3.gif"));
    }

    public void run() {
        final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        BusyIndicator.showWhile((Display)window.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                String supportUrl = Application.getPrefs().get("lfs_support_url", "https://moonlits.atlassian.net/servicedesk/customer/portals");
                if (Util.isLinux()) {
                    if (!Program.launch((String)supportUrl)) {
                        MessageDialog.openError((Shell)window.getShell(), (String)"Error", (String)("Unable to run default browser. Please navigate to this url manually: " + supportUrl));
                    }
                    return;
                }
                if (window != null) {
                    try {
                        IWorkbenchPage page = window.getActivePage();
                        IEditorReference[] refs = page.getEditorReferences();
                        if (refs == null) {
                            return;
                        }
                        int i = 0;
                        while (i < refs.length) {
                            IEditorPart editor = refs[i].getEditor(false);
                            if (editor instanceof SupportEditor) {
                                page.activate((IWorkbenchPart)editor);
                            }
                            ++i;
                        }
                        page.openEditor((IEditorInput)new SupportInput(supportUrl), "com.moonlit.logfaces.client.editors.SupportEditor");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        MessageDialog.openError((Shell)window.getShell(), (String)"Error", (String)("Unable to open support page: " + e.getMessage()));
                    }
                }
            }
        });
    }
}

