/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.jobs.ShowSourceJob;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ShowSourceAction
extends Action {
    private String fileName;
    private int lineNumber;
    private String urlPath = "";

    public ShowSourceAction(LoggingEventVO event) {
        this.urlPath = this.fileName = event.getLocFileName();
        String locationClass = event.getLocClassName();
        if (locationClass != null && StringUtils.countOccurrencesOf(locationClass, ".") > 1) {
            this.urlPath = StringUtils.replace(locationClass, ".", "/");
            int index = this.urlPath.lastIndexOf("/");
            this.urlPath = this.urlPath.substring(0, index);
            this.urlPath = String.valueOf(this.urlPath) + "/";
            this.urlPath = String.valueOf(this.urlPath) + this.fileName;
        }
        try {
            this.lineNumber = Integer.parseInt(event.getLocLineNumber());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setText("Show source code");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/class.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setEnabled(this.fileName != null && this.lineNumber != 0);
    }

    public ShowSourceAction(String pack, String fileName, int lineNumber) {
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.urlPath = fileName;
        if (pack != null && StringUtils.countOccurrencesOf(pack, ".") > 2) {
            this.urlPath = StringUtils.replace(pack, ".", "/");
            this.urlPath = String.valueOf(this.urlPath) + "/";
            this.urlPath = String.valueOf(this.urlPath) + fileName;
        }
        this.setText("Show source code");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/class.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setEnabled(fileName != null && lineNumber != 0);
    }

    public void run() {
        if (this.fileName == null || this.lineNumber == 0) {
            Utils.displayWarning("Source file unknown", "This event doesn't have location information.");
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ShowSourceJob job = new ShowSourceJob(window, this.fileName, this.urlPath, this.lineNumber);
        job.setUser(true);
        job.schedule();
    }
}

