/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.editors.DashboardEditor;
import com.moonlit.logfaces.client.utils.Utils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ShowAlertsAction
extends Action
implements IPartListener {
    private IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    private static final Logger log = LogManager.getLogger(ShowAlertsAction.class);

    public ShowAlertsAction() {
        this.setText("Alerts");
        this.setToolTipText("Shows list of outstanding server alerts");
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/task_warning_misc.gif"));
    }

    public void run() {
        if (this.window != null && this.window.getActivePage() != null) {
            try {
                Utils.activateEditorOtherThan(DashboardEditor.class);
                IViewPart view = this.window.getActivePage().findView("com.moonlit.logfaces.client.alertsView");
                if (view == null) {
                    this.window.getActivePage().showView("com.moonlit.logfaces.client.alertsView");
                } else {
                    this.window.getActivePage().hideView(view);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }

    public void hide() {
        if (this.window != null && this.window.getActivePage() != null) {
            try {
                IViewPart view = this.window.getActivePage().findView("com.moonlit.logfaces.client.alertsView");
                this.window.getActivePage().hideView(view);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void partActivated(IWorkbenchPart part) {
        this.setEnabled(!(part instanceof DashboardEditor));
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        this.setEnabled(true);
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

