/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.editors.AdminConsoleEditor;
import com.moonlit.logfaces.client.editors.AdminConsoleInput;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ShowAdminConsoleAction
extends Action
implements IAction {
    private String offset = "";

    public ShowAdminConsoleAction() {
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setText("&Server administration");
        this.setToolTipText("Open server administration console");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/eclipse3_task.gif"));
    }

    public ShowAdminConsoleAction(String offset) {
        this.offset = offset;
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setText("&Administration console");
        this.setToolTipText("Open administration console");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/eclipse3_task.gif"));
    }

    public void run() {
        final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (LfsConnector.getInstance().getConnection() == null) {
            MessageDialog.openError((Shell)window.getShell(), (String)"Not connected to server", (String)"Please try again when connection regained");
            return;
        }
        BusyIndicator.showWhile((Display)window.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IEclipsePreferences prefs = Application.getPrefs();
                String adminUrl = String.format("%s://%s:%d%s", prefs.getBoolean("lfs_ssl", false) ? "https" : "http", prefs.get("lfs_host_name", "localhost"), prefs.getInt("lfs_port_num", 80), StringUtils.hasText(ShowAdminConsoleAction.this.offset) ? ShowAdminConsoleAction.this.offset : "");
                if (Util.isLinux()) {
                    if (!Program.launch((String)adminUrl)) {
                        MessageDialog.openError((Shell)window.getShell(), (String)"Error", (String)("Unable to run default browser. Please navigate to this url manually: " + adminUrl));
                    }
                    return;
                }
                if (window != null) {
                    try {
                        IWorkbenchPage page = window.getActivePage();
                        IEditorReference[] refs = page.getEditorReferences();
                        if (refs == null) {
                            return;
                        }
                        int i = 0;
                        while (i < refs.length) {
                            IEditorPart editor = refs[i].getEditor(false);
                            if (editor instanceof AdminConsoleEditor) {
                                page.activate((IWorkbenchPart)editor);
                                return;
                            }
                            ++i;
                        }
                        page.openEditor((IEditorInput)new AdminConsoleInput(adminUrl), "com.moonlit.logfaces.client.editors.AdminConsoleEditor");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        MessageDialog.openError((Shell)window.getShell(), (String)"Error", (String)("Unable to open admin page: " + e.getMessage()));
                    }
                }
            }
        });
    }
}

