/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.net.LfsConnector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.commons.io.IOUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ShareWorkspaceAction
extends Action {
    public ShareWorkspaceAction() {
        this.setText("Share this workspace");
        this.setToolTipText("Sends current workspace to logFaces server to be visible for other users");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/contacts.png"));
        this.setId(((Object)((Object)this)).getClass().getName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        workspace = WorkspaceHolder.getInstance().getCurrentWorkspace();
        connector = LfsConnector.getInstance();
        if (!connector.isConnected()) {
            MessageDialog.openError((Shell)window.getShell(), (String)"No connection", (String)"Unable to share workspace because there is no connection to logFaces server");
            return;
        }
        if (window == null) return;
        if (workspace == null) return;
        is = null;
        try {
            wsname = null;
            list = connector.getConnection().listWorkspaces(connector.getSid());
            while (true) {
                input = new InputDialog(window.getShell(), "Workspace name", "Give a shared name to this workspace\nOther users will be able to use this workspace by this name:", workspace.getName(), null);
                if (input.open() == 0) continue;
                break;
            }
        }
        catch (UndeclaredThrowableException e) {
            MessageDialog.openError((Shell)window.getShell(), (String)"Not supported", (String)"This server version doesn't support shared workspaces.\nConsider upgrading.");
            IOUtils.closeQuietly(is);
            return;
        }
        catch (Exception ex) {
            try {
                cause = ex.getCause();
                MessageDialog.openError((Shell)window.getShell(), (String)"Export failed", (String)(cause != null ? cause.getMessage() : ex.getMessage()));
                return;
            }
            catch (Throwable var8_10) {
                throw var8_10;
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
        IOUtils.closeQuietly(is);
        return;
        {
            if (list.contains(wsname = input.getValue()) && !MessageDialog.openQuestion((Shell)window.getShell(), (String)"Please confirm", (String)"Workspace with such name already shared on this server.\nNote that replacing it will affect other users.\n\nOK to replace?")) ** continue;
            os = new ByteArrayOutputStream();
            workspace.save(wsname, os, false);
            is = new ByteArrayInputStream(os.toString().trim().getBytes());
            connector.getConnection().uploadWorkspace(connector.getSid(), wsname, true, (InputStream)is);
            MessageDialog.openInformation((Shell)window.getShell(), (String)"Done", (String)"Workspace is uploaded to your logFaces server.\nOthers may now use it by doing 'File/Import workspace from server' ");
        }
        IOUtils.closeQuietly((InputStream)is);
    }
}

