/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.dialogs.DateTimeChooser;
import com.moonlit.logfaces.client.dialogs.DateTimeRangeChooser;
import com.moonlit.logfaces.client.jobs.FetchQueryRapidJob;
import com.moonlit.logfaces.client.jobs.QueryDataFetcher;
import com.moonlit.logfaces.client.model.ComponentModel;
import com.moonlit.logfaces.client.model.ComponentPackageModel;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.model.RepositoryDomainModel;
import com.moonlit.logfaces.client.model.RepositoryHostModel;
import com.moonlit.logfaces.client.model.RepositoryLoggerModel;
import com.moonlit.logfaces.client.model.RepositoryPackageModel;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.criteria.Rule;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import java.util.TimeZone;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SelectionQueryAction
extends Action {
    private TimeRange range;
    private int severity;
    private String name;
    private IStructuredSelection selection;

    public SelectionQueryAction(IStructuredSelection selection, String name, TimeRange range, int severity) {
        this.range = range;
        this.severity = severity;
        this.name = name;
        this.selection = selection;
        this.setText(name);
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/clock.gif"));
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (LfsConnector.getInstance().getConnection() == null) {
            MessageDialog.openError((Shell)window.getShell(), (String)"Not connected to server", (String)"Please try again when connection regained");
            return;
        }
        QueryVO query = this.makeQueryObject(this.selection.toArray()[0]);
        if (TimeRange.PARTICULAR_DAY.equals((Object)this.range)) {
            DateTimeChooser dlg = new DateTimeChooser(window.getShell(), System.currentTimeMillis(), TimeZone.getDefault());
            dlg.setTimeVisible(false);
            if (dlg.open() > 0) {
                return;
            }
            query.setTimeRange(this.range, dlg.getTime(), dlg.getTime() + 86400000L);
        }
        if (TimeRange.CUSTOM_RANGE.equals((Object)this.range)) {
            long now = System.currentTimeMillis();
            DateTimeRangeChooser dlg = new DateTimeRangeChooser(window.getShell(), now - 3600000L, now, TimeZone.getDefault());
            dlg.setTimeVisible(false);
            if (dlg.open() > 0) {
                return;
            }
            query.setTimeRange(this.range, dlg.getTime(), dlg.getTime2());
        }
        QueryDataFetcher fetcher = new QueryDataFetcher(query, true);
        FetchQueryRapidJob job = new FetchQueryRapidJob(fetcher);
        job.setUser(true);
        job.schedule();
    }

    private QueryVO makeQueryObject(Object o) {
        QueryVO vo = new QueryVO();
        vo.setLimit(-1);
        vo.setTimeRange(this.range, 0L, 0L);
        vo.setTimeZone(TimeZone.getDefault());
        JexlCriteria criteria = new JexlCriteria();
        Rule rule = criteria.addRule().addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)LfsLevel.toLevel((int)this.severity).name());
        vo.setCriteria((CriteriaFilter)criteria);
        if (o instanceof RepositoryDomainModel) {
            RepositoryDomainModel model = (RepositoryDomainModel)o;
            rule.addCondition((Object)EventAttribute.domainName, (Object)Operation.is, (Object)model.getName());
            vo.setName(String.format("%s (%s) %s", this.name, model.getName(), LfsLevel.toLevel((int)this.severity)));
        } else if (o instanceof RepositoryPackageModel) {
            RepositoryPackageModel model = (RepositoryPackageModel)o;
            rule.addCondition((Object)EventAttribute.domainName, (Object)Operation.is, (Object)model.getParent().getName());
            rule.addCondition((Object)EventAttribute.loggerName, (Object)Operation.contains, (Object)model.getName());
            vo.setName(String.format("%s (%s) %s", this.name, model.getName(), LfsLevel.toLevel((int)this.severity)));
        } else if (o instanceof RepositoryLoggerModel) {
            RepositoryLoggerModel model = (RepositoryLoggerModel)o;
            rule.addCondition((Object)EventAttribute.domainName, (Object)Operation.is, (Object)model.getDomainName());
            rule.addCondition((Object)EventAttribute.loggerName, (Object)Operation.is, (Object)model.getFullName());
            vo.setName(String.format("%s (%s) %s", this.name, model.getName(), LfsLevel.toLevel((int)this.severity)));
        } else if (o instanceof RepositoryHostModel) {
            RepositoryHostModel model = (RepositoryHostModel)o;
            rule.addCondition((Object)EventAttribute.hostName, (Object)Operation.is, (Object)model.getName());
            vo.setName(String.format("%s (%s) %s", this.name, model.getName(), LfsLevel.toLevel((int)this.severity)));
        } else if (o instanceof ComponentModel) {
            criteria.removeRule(rule);
            ComponentModel model = (ComponentModel)o;
            String[] stringArray = model.getPackageNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String packageName = stringArray[n2];
                rule = criteria.addRule().addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)LfsLevel.toLevel((int)this.severity).name());
                rule.addCondition((Object)EventAttribute.loggerName, (Object)Operation.contains, (Object)packageName);
                ++n2;
            }
            vo.setName(String.format("%s (%s) %s", this.name, model.getName(), LfsLevel.toLevel((int)this.severity)));
        } else if (o instanceof ComponentPackageModel) {
            ComponentPackageModel model = (ComponentPackageModel)((Object)o);
            rule.addCondition((Object)EventAttribute.loggerName, (Object)Operation.contains, (Object)model.getName());
            vo.setName(String.format("%s (%s) %s", this.name, model.getName(), LfsLevel.toLevel((int)this.severity)));
        }
        return vo;
    }
}

