/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.WorkspaceHolder;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class SaveWorkspaceAction
extends Action {
    private final IWorkbenchWindow window;

    public SaveWorkspaceAction(IWorkbenchWindow window) {
        this.window = window;
        this.setText("Save workspace as..");
        this.setToolTipText("Save current workspace with different name");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/saveas_edit.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
    }

    public void run() {
        if (this.window != null) {
            Shell shell = this.window.getShell();
            InputDialog dialog = new InputDialog(shell, "Save workspace", "Workspace name :", "", null);
            if (dialog.open() != 0) {
                return;
            }
            String workspaceName = dialog.getValue();
            if (workspaceName == null) {
                return;
            }
            if (workspaceName.length() == 0) {
                return;
            }
            try {
                WorkspaceHolder.getInstance().saveAs(workspaceName);
                if (MessageDialog.openQuestion((Shell)shell, (String)"Workspace created", (String)("Workspace [" + workspaceName + "] created, would you like to switch to it?"))) {
                    WorkspaceHolder.getInstance().switchTo(workspaceName);
                }
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)shell, (String)"Failed", (String)ex.getMessage());
            }
        }
    }
}

