/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.dialogs.PluginArgumentsDialog;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.jobs.RunPluginJob;
import com.moonlit.logfaces.client.model.PluginVO;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.core.LogFacesPlugin;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RunPluginAction
extends Action {
    private LogFacesPlugin plugin;
    List<LogEvent> events = Lists.newArrayList();

    public RunPluginAction(PluginVO pvo, LogView view, TableItem[] selection) {
        this.plugin = pvo.getPlugin();
        this.setText(this.plugin.getName());
        this.setToolTipText("Run this plugin...");
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/plugin.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
        if (selection != null) {
            TableItem[] tableItemArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                this.events.add((LogEvent)item.getData());
                ++n2;
            }
        }
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (LfsConnector.getInstance().getConnection() == null) {
            MessageDialog.openError((Shell)window.getShell(), (String)"Not connected to server", (String)"Please try again when connection regained");
            return;
        }
        Map<Object, Object> args = Maps.newLinkedHashMap();
        List names = this.plugin.getArgs();
        if (names != null && !names.isEmpty()) {
            PluginArgumentsDialog dlg = new PluginArgumentsDialog(Application.getShell(), this.plugin);
            if (dlg.open() != 0) {
                return;
            }
            args = dlg.getArguments();
        }
        RunPluginJob job = new RunPluginJob(this.plugin, this.events, args);
        job.setUser(true);
        job.schedule();
    }

    public void dispose() {
    }
}

