/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.editors.LogEditorInput;
import com.moonlit.logfaces.client.model.ComponentModel;
import com.moonlit.logfaces.client.model.ComponentPackageModel;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.model.PerspectiveVO;
import com.moonlit.logfaces.client.model.RepositoryDomainModel;
import com.moonlit.logfaces.client.model.RepositoryHostModel;
import com.moonlit.logfaces.client.model.RepositoryLoggerModel;
import com.moonlit.logfaces.client.model.RepositoryPackageModel;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.prefs.PersistentCounter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class QuickViewAction
extends Action {
    private LfsLevel level;
    private String name;
    private IStructuredSelection selection;

    public QuickViewAction(IStructuredSelection selection, LfsLevel level) {
        super("Create " + level.toString() + " perspective");
        this.level = level;
        this.selection = selection;
        this.setImageDescriptor(EventStyles.getInstance().getStyle(level.intLevel()).getImageDescriptor());
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (LfsConnector.getInstance().getConnection() == null) {
            MessageDialog.openError((Shell)window.getShell(), (String)"Not connected to server", (String)"Please try again when connection regained");
            return;
        }
        if (this.selection.isEmpty()) {
            MessageDialog.openWarning((Shell)window.getShell(), (String)"Missing selection", (String)"Please select some loggers from the repository");
            return;
        }
        try {
            this.name = this.makeDefaultName(this.selection);
            PerspectiveVO vo = this.makeQuickPerspective(this.selection);
            vo.setActivated(true);
            LogEditorInput input = new LogEditorInput(vo);
            IWorkbenchPage page = window.getActivePage();
            page.openEditor((IEditorInput)input, "com.moonlit.logfaces.client.LogEditor");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageDialog.openError(null, (String)"Operation failed", (String)ex.getMessage());
        }
    }

    private String makeDefaultName(IStructuredSelection selection) {
        Object selected = selection.getFirstElement();
        if (selection.size() == 1) {
            if (selected instanceof RepositoryDomainModel) {
                return ((RepositoryDomainModel)selected).getName() + " (" + this.level.toString() + ")";
            }
            if (selected instanceof RepositoryPackageModel) {
                return ((RepositoryPackageModel)selected).getName() + " (" + this.level.toString() + ")";
            }
            if (selected instanceof ComponentModel) {
                return ((ComponentModel)selected).getName() + " (" + this.level.toString() + ")";
            }
            if (selected instanceof ComponentPackageModel) {
                return ((ComponentPackageModel)((Object)selected)).getName() + " (" + this.level.toString() + ")";
            }
            if (selected instanceof RepositoryHostModel) {
                return ((RepositoryHostModel)selected).getName() + " (" + this.level.toString() + ")";
            }
        }
        return String.format("Perspective (%d)", PersistentCounter.getInstance().getCounter());
    }

    private PerspectiveVO makeQuickPerspective(IStructuredSelection selection) {
        PerspectiveVO vo = new PerspectiveVO();
        vo.setName(this.name);
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            PlatformObject pack;
            if (selected[i] instanceof RepositoryDomainModel) {
                RepositoryDomainModel domain = (RepositoryDomainModel)selected[i];
                vo.getCriteria().addRule().addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)this.level.toString()).addCondition((Object)EventAttribute.domainName, (Object)Operation.is, (Object)domain.getName());
            } else if (selected[i] instanceof RepositoryPackageModel) {
                pack = (RepositoryPackageModel)selected[i];
                vo.getCriteria().addRule().addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)this.level.toString()).addCondition((Object)EventAttribute.domainName, (Object)Operation.is, (Object)pack.getDomainName()).addCondition((Object)EventAttribute.loggerName, (Object)Operation.contains, (Object)pack.getName());
            }
            if (selected[i] instanceof RepositoryLoggerModel) {
                RepositoryLoggerModel logger = (RepositoryLoggerModel)selected[i];
                vo.getCriteria().addRule().addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)this.level.toString()).addCondition((Object)EventAttribute.domainName, (Object)Operation.is, (Object)logger.getDomainName()).addCondition((Object)EventAttribute.loggerName, (Object)Operation.is, (Object)logger.getFullName());
            }
            if (selected[i] instanceof RepositoryHostModel) {
                RepositoryHostModel model = (RepositoryHostModel)selected[i];
                vo.getCriteria().addRule().addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)this.level.toString()).addCondition((Object)EventAttribute.hostName, (Object)Operation.is, (Object)model.getName());
            }
            if (selected[i] instanceof ComponentModel) {
                String[] packages;
                ComponentModel component = (ComponentModel)selected[i];
                String[] stringArray = packages = component.getPackageNames();
                int n = packages.length;
                int n2 = 0;
                while (n2 < n) {
                    String pack2 = stringArray[n2];
                    vo.getCriteria().addRule().addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)this.level.toString()).addCondition((Object)EventAttribute.loggerName, (Object)Operation.contains, (Object)pack2);
                    ++n2;
                }
            }
            if (selected[i] instanceof ComponentPackageModel) {
                pack = (ComponentPackageModel)((Object)selected[i]);
                vo.getCriteria().addRule().addCondition((Object)EventAttribute.loggerName, (Object)Operation.contains, (Object)pack.getName());
            }
            ++i;
        }
        return vo;
    }
}

