/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.actions;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.gis.GisLocation;
import com.moonlit.logfaces.client.jobs.FetchQueryRapidJob;
import com.moonlit.logfaces.client.jobs.QueryDataFetcher;
import com.moonlit.logfaces.client.model.LogHeaderInfoVO;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.conf.MdcMap;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.criteria.Operation;
import java.util.TimeZone;
import org.eclipse.jface.action.Action;

public class QueryGisAction
extends Action {
    private QueryVO query;

    public QueryGisAction(GisLocation location, TimeRange range, TimeZone timeZone) {
        this.setId(((Object)((Object)this)).getClass().getName());
        this.setText(range.toString());
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/clock.gif"));
        this.query = new QueryVO(location.getIp(), -1, range.getTime(true, System.currentTimeMillis()), System.currentTimeMillis());
        this.query.setTimeZone(timeZone);
        JexlCriteria criteria = new JexlCriteria();
        criteria.addRule().addCondition((Object)EventAttribute.hostName, (Object)Operation.contains, (Object)location.getIp());
        criteria.addRule().addCondition((Object)EventAttribute.message, (Object)Operation.contains, (Object)location.getIp());
        for (String name : MdcMap.getNames()) {
            criteria.addRule().addCondition((Object)name, (Object)Operation.contains, (Object)location.getIp());
        }
        this.query.setCriteria((CriteriaFilter)criteria);
    }

    public void run() {
        this.query.setHeaders((LogHeaderInfoVO[])Utils.getContextVariable("headers"));
        FetchQueryRapidJob job = new FetchQueryRapidJob(new QueryDataFetcher(this.query, true));
        job.setUser(true);
        job.schedule();
    }
}

